/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.IoeClientProcessEvent;
import com.cisco.pt.ipc.events.IoeClientProcessEventListener;
import com.cisco.pt.ipc.sim.IoeClientProcess;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IoeClientProcessEventRegistry
extends IPCEventRegistry {
    protected Set<IoeClientProcessEventListener> globalListeners = new HashSet<IoeClientProcessEventListener>();
    protected Map<String, Set<IoeClientProcessEventListener>> specificObjectListeners = new HashMap<String, Set<IoeClientProcessEventListener>>();
    private static Log logger = LogFactory.getLog(IoeClientProcessEventRegistry.class);

    public IoeClientProcessEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "IoeClientProcess";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        IoeClientProcessEvent evt = null;
        if (eventName.equalsIgnoreCase("inputReceived")) {
            evt = new IoeClientProcessEvent.InputReceived(event);
        } else if (eventName.equalsIgnoreCase("stateSet")) {
            evt = new IoeClientProcessEvent.StateSet(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (IoeClientProcessEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<IoeClientProcessEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (IoeClientProcessEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(IoeClientProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("inputReceived");
                this.register("stateSet");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(IoeClientProcessEventListener listener, IoeClientProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<IoeClientProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<IoeClientProcessEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "inputReceived");
                this.register(uuid, "stateSet");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(IoeClientProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("inputReceived");
                this.deregister("stateSet");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(IoeClientProcessEventListener listener, IoeClientProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<IoeClientProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "inputReceived");
            this.deregister(uuid, "stateSet");
            specificListeners.remove(listener);
        }
    }

    public void addListener(IoeClientProcessEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(IoeClientProcessEventListener listener, IoeClientProcess objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(IoeClientProcessEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(IoeClientProcessEventListener listener, IoeClientProcess objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

