/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.NATProcessEvent;
import com.cisco.pt.ipc.events.NATProcessEventListener;
import com.cisco.pt.ipc.sim.NATProcess;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NATProcessEventRegistry
extends IPCEventRegistry {
    protected Set<NATProcessEventListener> globalListeners = new HashSet<NATProcessEventListener>();
    protected Map<String, Set<NATProcessEventListener>> specificObjectListeners = new HashMap<String, Set<NATProcessEventListener>>();
    private static Log logger = LogFactory.getLog(NATProcessEventRegistry.class);

    public NATProcessEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "NATProcess";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        NATProcessEvent evt = null;
        if (eventName.equalsIgnoreCase("updateTableEvent")) {
            evt = new NATProcessEvent.UpdateTableEvent(event);
        } else if (eventName.equalsIgnoreCase("closeTableEvent")) {
            evt = new NATProcessEvent.CloseTableEvent(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (NATProcessEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<NATProcessEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (NATProcessEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(NATProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("updateTableEvent");
                this.register("closeTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(NATProcessEventListener listener, NATProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<NATProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<NATProcessEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "updateTableEvent");
                this.register(uuid, "closeTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(NATProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("updateTableEvent");
                this.deregister("closeTableEvent");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(NATProcessEventListener listener, NATProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<NATProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "updateTableEvent");
            this.deregister(uuid, "closeTableEvent");
            specificListeners.remove(listener);
        }
    }

    public void addListener(NATProcessEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(NATProcessEventListener listener, NATProcess objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(NATProcessEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(NATProcessEventListener listener, NATProcess objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

