/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.NdProcessEvent;
import com.cisco.pt.ipc.events.NdProcessEventListener;
import com.cisco.pt.ipc.sim.NdProcess;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NdProcessEventRegistry
extends IPCEventRegistry {
    protected Set<NdProcessEventListener> globalListeners = new HashSet<NdProcessEventListener>();
    protected Map<String, Set<NdProcessEventListener>> specificObjectListeners = new HashMap<String, Set<NdProcessEventListener>>();
    private static Log logger = LogFactory.getLog(NdProcessEventRegistry.class);

    public NdProcessEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "NdProcess";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        NdProcessEvent evt = null;
        if (eventName.equalsIgnoreCase("autoConfigFailed")) {
            evt = new NdProcessEvent.AutoConfigFailed(event);
        } else if (eventName.equalsIgnoreCase("autoConfigSucceed")) {
            evt = new NdProcessEvent.AutoConfigSucceed(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (NdProcessEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<NdProcessEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (NdProcessEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(NdProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("autoConfigFailed");
                this.register("autoConfigSucceed");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(NdProcessEventListener listener, NdProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<NdProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<NdProcessEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "autoConfigFailed");
                this.register(uuid, "autoConfigSucceed");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(NdProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("autoConfigFailed");
                this.deregister("autoConfigSucceed");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(NdProcessEventListener listener, NdProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<NdProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "autoConfigFailed");
            this.deregister(uuid, "autoConfigSucceed");
            specificListeners.remove(listener);
        }
    }

    public void addListener(NdProcessEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(NdProcessEventListener listener, NdProcess objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(NdProcessEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(NdProcessEventListener listener, NdProcess objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

