/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.PhysicalToolbarEvent;
import com.cisco.pt.ipc.events.PhysicalToolbarEventListener;
import com.cisco.pt.ipc.ui.PhysicalToolbar;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhysicalToolbarEventRegistry
extends IPCEventRegistry {
    protected Set<PhysicalToolbarEventListener> globalListeners = new HashSet<PhysicalToolbarEventListener>();
    protected Map<String, Set<PhysicalToolbarEventListener>> specificObjectListeners = new HashMap<String, Set<PhysicalToolbarEventListener>>();
    private static Log logger = LogFactory.getLog(PhysicalToolbarEventRegistry.class);

    public PhysicalToolbarEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "PhysicalToolbar";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        PhysicalToolbarEvent.PhysicalLocationDialogShown evt = null;
        if (!eventName.equalsIgnoreCase("physicalLocationDialogShown")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new PhysicalToolbarEvent.PhysicalLocationDialogShown(event);
        for (PhysicalToolbarEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<PhysicalToolbarEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (PhysicalToolbarEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(PhysicalToolbarEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("physicalLocationDialogShown");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(PhysicalToolbarEventListener listener, PhysicalToolbar objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PhysicalToolbarEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<PhysicalToolbarEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "physicalLocationDialogShown");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(PhysicalToolbarEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("physicalLocationDialogShown");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(PhysicalToolbarEventListener listener, PhysicalToolbar objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PhysicalToolbarEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "physicalLocationDialogShown");
            specificListeners.remove(listener);
        }
    }

    public void addListener(PhysicalToolbarEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(PhysicalToolbarEventListener listener, PhysicalToolbar objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(PhysicalToolbarEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(PhysicalToolbarEventListener listener, PhysicalToolbar objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

