/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.Pop3ResponseType;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class Pop3ClientEvent
extends IPCEvent {
    public EventType type;

    public Pop3ClientEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        MAIL_RECEIVED,
        ERROR_RECEIVING_MAIL;

    }

    public static class ErrorReceivingMail
    extends Pop3ClientEvent {
        public Pop3ResponseType responseType;

        public ErrorReceivingMail(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ERROR_RECEIVING_MAIL;
            this.responseType = Pop3ResponseType.fromIntValue((Integer)ltv.getEventParameters().get(0));
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tresponseType = " + (Object)((Object)this.responseType);
        }
    }

    public static class MailReceived
    extends Pop3ClientEvent {
        public String sender;
        public String subject;
        public String dateTime;
        public String body;

        public MailReceived(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.MAIL_RECEIVED;
            this.sender = (String)ltv.getEventParameters().get(0);
            this.subject = (String)ltv.getEventParameters().get(1);
            this.dateTime = (String)ltv.getEventParameters().get(2);
            this.body = (String)ltv.getEventParameters().get(3);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tsender = " + this.sender + "\n\tsubject = " + this.subject + "\n\tdateTime = " + this.dateTime + "\n\tbody = " + this.body;
        }
    }
}

