/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.RemoteNetworkEvent;
import com.cisco.pt.ipc.events.RemoteNetworkEventListener;
import com.cisco.pt.ipc.sim.RemoteNetwork;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteNetworkEventRegistry
extends IPCEventRegistry {
    protected Set<RemoteNetworkEventListener> globalListeners = new HashSet<RemoteNetworkEventListener>();
    protected Map<String, Set<RemoteNetworkEventListener>> specificObjectListeners = new HashMap<String, Set<RemoteNetworkEventListener>>();
    private static Log logger = LogFactory.getLog(RemoteNetworkEventRegistry.class);

    public RemoteNetworkEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "RemoteNetwork";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        RemoteNetworkEvent evt = null;
        if (eventName.equalsIgnoreCase("peerConnected")) {
            evt = new RemoteNetworkEvent.PeerConnected(event);
        } else if (eventName.equalsIgnoreCase("peerDisconnected")) {
            evt = new RemoteNetworkEvent.PeerDisconnected(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (RemoteNetworkEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<RemoteNetworkEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (RemoteNetworkEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(RemoteNetworkEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("peerConnected");
                this.register("peerDisconnected");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(RemoteNetworkEventListener listener, RemoteNetwork objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<RemoteNetworkEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<RemoteNetworkEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "peerConnected");
                this.register(uuid, "peerDisconnected");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(RemoteNetworkEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("peerConnected");
                this.deregister("peerDisconnected");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(RemoteNetworkEventListener listener, RemoteNetwork objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<RemoteNetworkEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "peerConnected");
            this.deregister(uuid, "peerDisconnected");
            specificListeners.remove(listener);
        }
    }

    public void addListener(RemoteNetworkEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(RemoteNetworkEventListener listener, RemoteNetwork objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(RemoteNetworkEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(RemoteNetworkEventListener listener, RemoteNetwork objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

