/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.IPV6Address;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class RoutingProcessv6Event
extends IPCEvent {
    public EventType type;

    public RoutingProcessv6Event(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        ROUTE_ADDED,
        ROUTE_REMOVED,
        NETWORK_ADDED,
        NETWORK_REMOVED;

    }

    public static class NetworkRemoved
    extends RoutingProcessv6Event {
        public IPV6Address network;
        public IPV6Address subnetMask;

        public NetworkRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.NETWORK_REMOVED;
            this.network = (IPV6Address)ltv.getEventParameters().get(0);
            this.subnetMask = (IPV6Address)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tsubnetMask = " + this.subnetMask;
        }
    }

    public static class NetworkAdded
    extends RoutingProcessv6Event {
        public IPV6Address network;
        public IPV6Address subnetMask;

        public NetworkAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.NETWORK_ADDED;
            this.network = (IPV6Address)ltv.getEventParameters().get(0);
            this.subnetMask = (IPV6Address)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tsubnetMask = " + this.subnetMask;
        }
    }

    public static class RouteRemoved
    extends RoutingProcessv6Event {
        public IPV6Address network;
        public IPV6Address mask;
        public int metric;
        public int distance;
        public IPV6Address nexthop;
        public String portName;
        public String protocolCode;

        public RouteRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ROUTE_REMOVED;
            this.network = (IPV6Address)ltv.getEventParameters().get(0);
            this.mask = (IPV6Address)ltv.getEventParameters().get(1);
            this.metric = (Integer)ltv.getEventParameters().get(2);
            this.distance = (Integer)ltv.getEventParameters().get(3);
            this.nexthop = (IPV6Address)ltv.getEventParameters().get(4);
            this.portName = (String)ltv.getEventParameters().get(5);
            this.protocolCode = (String)ltv.getEventParameters().get(6);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tmask = " + this.mask + "\n\tmetric = " + this.metric + "\n\tdistance = " + this.distance + "\n\tnexthop = " + this.nexthop + "\n\tportName = " + this.portName + "\n\tprotocolCode = " + this.protocolCode;
        }
    }

    public static class RouteAdded
    extends RoutingProcessv6Event {
        public IPV6Address network;
        public IPV6Address mask;
        public int metric;
        public int distance;
        public IPV6Address nexthop;
        public String portName;
        public String protocolCode;

        public RouteAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ROUTE_ADDED;
            this.network = (IPV6Address)ltv.getEventParameters().get(0);
            this.mask = (IPV6Address)ltv.getEventParameters().get(1);
            this.metric = (Integer)ltv.getEventParameters().get(2);
            this.distance = (Integer)ltv.getEventParameters().get(3);
            this.nexthop = (IPV6Address)ltv.getEventParameters().get(4);
            this.portName = (String)ltv.getEventParameters().get(5);
            this.protocolCode = (String)ltv.getEventParameters().get(6);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tmask = " + this.mask + "\n\tmetric = " + this.metric + "\n\tdistance = " + this.distance + "\n\tnexthop = " + this.nexthop + "\n\tportName = " + this.portName + "\n\tprotocolCode = " + this.protocolCode;
        }
    }
}

