/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.SystemFileWatcherEvent;
import com.cisco.pt.ipc.events.SystemFileWatcherEventListener;
import com.cisco.pt.ipc.ui.SystemFileWatcher;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemFileWatcherEventRegistry
extends IPCEventRegistry {
    protected Set<SystemFileWatcherEventListener> globalListeners = new HashSet<SystemFileWatcherEventListener>();
    protected Map<String, Set<SystemFileWatcherEventListener>> specificObjectListeners = new HashMap<String, Set<SystemFileWatcherEventListener>>();
    private static Log logger = LogFactory.getLog(SystemFileWatcherEventRegistry.class);

    public SystemFileWatcherEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "SystemFileWatcher";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        SystemFileWatcherEvent evt = null;
        if (eventName.equalsIgnoreCase("fileChanged")) {
            evt = new SystemFileWatcherEvent.FileChanged(event);
        } else if (eventName.equalsIgnoreCase("directoryChanged")) {
            evt = new SystemFileWatcherEvent.DirectoryChanged(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (SystemFileWatcherEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<SystemFileWatcherEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (SystemFileWatcherEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(SystemFileWatcherEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("fileChanged");
                this.register("directoryChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(SystemFileWatcherEventListener listener, SystemFileWatcher objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<SystemFileWatcherEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<SystemFileWatcherEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "fileChanged");
                this.register(uuid, "directoryChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(SystemFileWatcherEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("fileChanged");
                this.deregister("directoryChanged");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(SystemFileWatcherEventListener listener, SystemFileWatcher objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<SystemFileWatcherEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "fileChanged");
            this.deregister(uuid, "directoryChanged");
            specificListeners.remove(listener);
        }
    }

    public void addListener(SystemFileWatcherEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(SystemFileWatcherEventListener listener, SystemFileWatcher objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(SystemFileWatcherEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(SystemFileWatcherEventListener listener, SystemFileWatcher objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

