/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.TreeNodeEvent;
import com.cisco.pt.ipc.events.TreeNodeEventListener;
import com.cisco.pt.ipc.system.TreeNode;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeNodeEventRegistry
extends IPCEventRegistry {
    protected Set<TreeNodeEventListener> globalListeners = new HashSet<TreeNodeEventListener>();
    protected Map<String, Set<TreeNodeEventListener>> specificObjectListeners = new HashMap<String, Set<TreeNodeEventListener>>();
    private static Log logger = LogFactory.getLog(TreeNodeEventRegistry.class);

    public TreeNodeEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "TreeNode";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        TreeNodeEvent.CheckChanged evt = null;
        if (!eventName.equalsIgnoreCase("checkChanged")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new TreeNodeEvent.CheckChanged(event);
        for (TreeNodeEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<TreeNodeEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (TreeNodeEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(TreeNodeEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("checkChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(TreeNodeEventListener listener, TreeNode objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<TreeNodeEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<TreeNodeEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "checkChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(TreeNodeEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("checkChanged");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(TreeNodeEventListener listener, TreeNode objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<TreeNodeEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "checkChanged");
            specificListeners.remove(listener);
        }
    }

    public void addListener(TreeNodeEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(TreeNodeEventListener listener, TreeNode objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(TreeNodeEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(TreeNodeEventListener listener, TreeNode objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

