/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.MACAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class VLANEvent
extends IPCEvent {
    public EventType type;

    public VLANEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        MAC_ENTRY_ADDED,
        MAC_ENTRY_REMOVED;

    }

    public static class MacEntryRemoved
    extends VLANEvent {
        public MACAddress mac;
        public String portName;
        public Boolean isDynamic;

        public MacEntryRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.MAC_ENTRY_REMOVED;
            this.mac = (MACAddress)ltv.getEventParameters().get(0);
            this.portName = (String)ltv.getEventParameters().get(1);
            this.isDynamic = (Boolean)ltv.getEventParameters().get(2);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tmac = " + this.mac + "\n\tportName = " + this.portName + "\n\tisDynamic = " + this.isDynamic;
        }
    }

    public static class MacEntryAdded
    extends VLANEvent {
        public MACAddress newMac;
        public String portName;
        public Boolean isDynamic;

        public MacEntryAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.MAC_ENTRY_ADDED;
            this.newMac = (MACAddress)ltv.getEventParameters().get(0);
            this.portName = (String)ltv.getEventParameters().get(1);
            this.isDynamic = (Boolean)ltv.getEventParameters().get(2);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnewMac = " + this.newMac + "\n\tportName = " + this.portName + "\n\tisDynamic = " + this.isDynamic;
        }
    }
}

