/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.WebViewEvent;
import com.cisco.pt.ipc.events.WebViewEventListener;
import com.cisco.pt.ipc.ui.WebView;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebViewEventRegistry
extends IPCEventRegistry {
    protected Set<WebViewEventListener> globalListeners = new HashSet<WebViewEventListener>();
    protected Map<String, Set<WebViewEventListener>> specificObjectListeners = new HashMap<String, Set<WebViewEventListener>>();
    private static Log logger = LogFactory.getLog(WebViewEventRegistry.class);

    public WebViewEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "WebView";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        WebViewEvent evt = null;
        if (eventName.equalsIgnoreCase("closeRequested")) {
            evt = new WebViewEvent.CloseRequested(event);
        } else if (eventName.equalsIgnoreCase("closed")) {
            evt = new WebViewEvent.Closed(event);
        } else if (eventName.equalsIgnoreCase("onFocus")) {
            evt = new WebViewEvent.OnFocus(event);
        } else if (eventName.equalsIgnoreCase("offFocus")) {
            evt = new WebViewEvent.OffFocus(event);
        } else if (eventName.equalsIgnoreCase("javascriptDone")) {
            evt = new WebViewEvent.JavascriptDone(event);
        } else if (eventName.equalsIgnoreCase("fileSystemResourceRequested")) {
            evt = new WebViewEvent.FileSystemResourceRequested(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (WebViewEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<WebViewEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (WebViewEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(WebViewEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("closeRequested");
                this.register("closed");
                this.register("onFocus");
                this.register("offFocus");
                this.register("javascriptDone");
                this.register("fileSystemResourceRequested");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(WebViewEventListener listener, WebView objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<WebViewEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<WebViewEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "closeRequested");
                this.register(uuid, "closed");
                this.register(uuid, "onFocus");
                this.register(uuid, "offFocus");
                this.register(uuid, "javascriptDone");
                this.register(uuid, "fileSystemResourceRequested");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(WebViewEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("closeRequested");
                this.deregister("closed");
                this.deregister("onFocus");
                this.deregister("offFocus");
                this.deregister("javascriptDone");
                this.deregister("fileSystemResourceRequested");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(WebViewEventListener listener, WebView objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<WebViewEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "closeRequested");
            this.deregister(uuid, "closed");
            this.deregister(uuid, "onFocus");
            this.deregister(uuid, "offFocus");
            this.deregister(uuid, "javascriptDone");
            this.deregister(uuid, "fileSystemResourceRequested");
            specificListeners.remove(listener);
        }
    }

    public void addListener(WebViewEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(WebViewEventListener listener, WebView objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(WebViewEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(WebViewEventListener listener, WebView objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

