/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;
import com.cisco.pt.ipc.sim.DeviceDescriptor;
import com.cisco.pt.ipc.ui.PhysicalObject;

public abstract class WorkspaceEvent
extends IPCEvent {
    public EventType type;

    public WorkspaceEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        PHYSICAL_OBJECT_ADDED,
        PHYSICAL_OBJECT_REMOVED,
        PHYSICAL_OBJECT_MOVED,
        CURRENT_PHYSICAL_OBJECT_CHANGED,
        DEVICE_TYPE_SELECTED,
        DEVICE_TYPE_DESELECTED;

    }

    public static class DeviceTypeDeselected
    extends WorkspaceEvent {
        public DeviceTypeDeselected(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DEVICE_TYPE_DESELECTED;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class DeviceTypeSelected
    extends WorkspaceEvent {
        public String str;
        public DeviceDescriptor dd;
        public Boolean bType;

        public DeviceTypeSelected(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DEVICE_TYPE_SELECTED;
            this.str = (String)ltv.getEventParameters().get(0);
            this.dd = (DeviceDescriptor)ltv.getEventParameters().get(1);
            this.bType = (Boolean)ltv.getEventParameters().get(2);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tstr = " + this.str + "\n\tdd = " + this.dd + "\n\tbType = " + this.bType;
        }
    }

    public static class CurrentPhysicalObjectChanged
    extends WorkspaceEvent {
        public PhysicalObject oldObject;
        public PhysicalObject newObject;

        public CurrentPhysicalObjectChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CURRENT_PHYSICAL_OBJECT_CHANGED;
            this.oldObject = (PhysicalObject)ltv.getEventParameters().get(0);
            this.newObject = (PhysicalObject)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\toldObject = " + this.oldObject + "\n\tnewObject = " + this.newObject;
        }
    }

    public static class PhysicalObjectMoved
    extends WorkspaceEvent {
        public PhysicalObject object;
        public UUID oldParentUuid;
        public PhysicalObject newParent;

        public PhysicalObjectMoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.PHYSICAL_OBJECT_MOVED;
            this.object = (PhysicalObject)ltv.getEventParameters().get(0);
            this.oldParentUuid = (UUID)ltv.getEventParameters().get(1);
            this.newParent = (PhysicalObject)ltv.getEventParameters().get(2);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tobject = " + this.object + "\n\toldParentUuid = " + this.oldParentUuid + "\n\tnewParent = " + this.newParent;
        }
    }

    public static class PhysicalObjectRemoved
    extends WorkspaceEvent {
        public UUID objectUuid;

        public PhysicalObjectRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.PHYSICAL_OBJECT_REMOVED;
            this.objectUuid = (UUID)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tobjectUuid = " + this.objectUuid;
        }
    }

    public static class PhysicalObjectAdded
    extends WorkspaceEvent {
        public PhysicalObject object;

        public PhysicalObjectAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.PHYSICAL_OBJECT_ADDED;
            this.object = (PhysicalObject)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tobject = " + this.object;
        }
    }
}

