/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.WorkspaceEvent;
import com.cisco.pt.ipc.events.WorkspaceEventListener;
import com.cisco.pt.ipc.ui.Workspace;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkspaceEventRegistry
extends IPCEventRegistry {
    protected Set<WorkspaceEventListener> globalListeners = new HashSet<WorkspaceEventListener>();
    protected Map<String, Set<WorkspaceEventListener>> specificObjectListeners = new HashMap<String, Set<WorkspaceEventListener>>();
    private static Log logger = LogFactory.getLog(WorkspaceEventRegistry.class);

    public WorkspaceEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "Workspace";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        WorkspaceEvent evt = null;
        if (eventName.equalsIgnoreCase("physicalObjectAdded")) {
            evt = new WorkspaceEvent.PhysicalObjectAdded(event);
        } else if (eventName.equalsIgnoreCase("physicalObjectRemoved")) {
            evt = new WorkspaceEvent.PhysicalObjectRemoved(event);
        } else if (eventName.equalsIgnoreCase("physicalObjectMoved")) {
            evt = new WorkspaceEvent.PhysicalObjectMoved(event);
        } else if (eventName.equalsIgnoreCase("currentPhysicalObjectChanged")) {
            evt = new WorkspaceEvent.CurrentPhysicalObjectChanged(event);
        } else if (eventName.equalsIgnoreCase("deviceTypeSelected")) {
            evt = new WorkspaceEvent.DeviceTypeSelected(event);
        } else if (eventName.equalsIgnoreCase("deviceTypeDeselected")) {
            evt = new WorkspaceEvent.DeviceTypeDeselected(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (WorkspaceEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<WorkspaceEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (WorkspaceEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(WorkspaceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("physicalObjectAdded");
                this.register("physicalObjectRemoved");
                this.register("physicalObjectMoved");
                this.register("currentPhysicalObjectChanged");
                this.register("deviceTypeSelected");
                this.register("deviceTypeDeselected");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(WorkspaceEventListener listener, Workspace objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<WorkspaceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<WorkspaceEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "physicalObjectAdded");
                this.register(uuid, "physicalObjectRemoved");
                this.register(uuid, "physicalObjectMoved");
                this.register(uuid, "currentPhysicalObjectChanged");
                this.register(uuid, "deviceTypeSelected");
                this.register(uuid, "deviceTypeDeselected");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(WorkspaceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("physicalObjectAdded");
                this.deregister("physicalObjectRemoved");
                this.deregister("physicalObjectMoved");
                this.deregister("currentPhysicalObjectChanged");
                this.deregister("deviceTypeSelected");
                this.deregister("deviceTypeDeselected");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(WorkspaceEventListener listener, Workspace objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<WorkspaceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "physicalObjectAdded");
            this.deregister(uuid, "physicalObjectRemoved");
            this.deregister(uuid, "physicalObjectMoved");
            this.deregister(uuid, "currentPhysicalObjectChanged");
            this.deregister(uuid, "deviceTypeSelected");
            this.deregister(uuid, "deviceTypeDeselected");
            specificListeners.remove(listener);
        }
    }

    public void addListener(WorkspaceEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(WorkspaceEventListener listener, Workspace objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(WorkspaceEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(WorkspaceEventListener listener, Workspace objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

