/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPAddress;
import com.cisco.pt.IPV6Address;
import com.cisco.pt.MACAddress;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCResponseFactory;
import com.cisco.pt.impl.LTVParsingError;
import com.cisco.pt.ipc.IPCData;
import com.cisco.pt.util.Pair;
import java.util.List;

public abstract class IPCDataImpl
implements IPCData {
    @Override
    public abstract void read(EncodedBuffer var1);

    protected boolean readBoolean(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)2);
        return buff.getBool();
    }

    protected byte readByte(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)1);
        return buff.getByte();
    }

    protected IPCData readIPCData(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)16);
        return IPCResponseFactory.getIPCData(buff);
    }

    protected double readDouble(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)7);
        return buff.getDouble();
    }

    protected float readFloat(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)6);
        return buff.getFloat();
    }

    protected int readInt(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)4);
        return buff.getInt();
    }

    protected IPAddress readIPAddress(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)10);
        return buff.getIPAddress();
    }

    protected IPV6Address readIPV6Address(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)11);
        return buff.getIPV6Address();
    }

    protected long readLong(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)5);
        return buff.getLong();
    }

    protected MACAddress readMACAddress(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)12);
        return buff.getMACAddress();
    }

    protected Pair<Object, Object> readPair(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)14);
        return IPCResponseFactory.getPairData(buff);
    }

    protected short readShort(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)3);
        return buff.getShort();
    }

    protected String readQString(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)9);
        return buff.getString();
    }

    protected String readString(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)8);
        return buff.getString();
    }

    protected UUID readUUID(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)13);
        return buff.getUUID();
    }

    protected List<Object> readVector(EncodedBuffer buff) {
        IPCDataImpl.checkType(buff, (byte)15);
        return IPCResponseFactory.getVectorData(buff);
    }

    protected static void checkType(EncodedBuffer buff, byte type) {
        byte dataType = buff.getByte();
        if (dataType != type) {
            throw new LTVParsingError("Type mis-match while parsing IPCData: expected <" + type + ">; got <" + dataType + "> instead");
        }
    }

    protected boolean pduReadBoolean(EncodedBuffer buff) {
        return buff.getBool();
    }

    protected byte pduReadByte(EncodedBuffer buff) {
        return buff.getByte();
    }

    protected IPCData pduReadIPCData(EncodedBuffer buff) {
        return IPCResponseFactory.getIPCData(buff);
    }

    protected double pduReadDouble(EncodedBuffer buff) {
        return buff.getDouble();
    }

    protected float pduReadFloat(EncodedBuffer buff) {
        return buff.getFloat();
    }

    protected int pduReadInt(EncodedBuffer buff) {
        return buff.getInt();
    }

    protected IPAddress pduReadIPAddress(EncodedBuffer buff) {
        return buff.getIPAddress();
    }

    protected IPV6Address pduReadIPV6Address(EncodedBuffer buff) {
        return buff.getIPV6Address();
    }

    protected long pduReadLong(EncodedBuffer buff) {
        return buff.getLong();
    }

    protected MACAddress pduReadMACAddress(EncodedBuffer buff) {
        return buff.getMACAddress();
    }

    protected Pair<Object, Object> pduReadPair(EncodedBuffer buff) {
        return IPCResponseFactory.getPairData(buff);
    }

    protected short pduReadShort(EncodedBuffer buff) {
        return buff.getShort();
    }

    protected String pduReadQString(EncodedBuffer buff) {
        return buff.getString();
    }

    protected String pduReadString(EncodedBuffer buff) {
        return buff.getString();
    }

    protected UUID pduReadUUID(EncodedBuffer buff) {
        return buff.getUUID();
    }

    protected List<Object> pduReadVector(EncodedBuffer buff, byte subType) {
        return IPCResponseFactory.getPduVectorData(buff, subType);
    }
}

