/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.MACAddress;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.CustomBluetoothProcess;
import com.cisco.pt.ipc.sim.impl.ProcessImpl;
import com.cisco.pt.ptmp.PacketTracerSession;

public class CustomBluetoothProcessImpl
extends ProcessImpl
implements CustomBluetoothProcess {
    public CustomBluetoothProcessImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public boolean start(UUID service) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("start");
        newCall.addUUIDParameter(service);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: CustomBluetoothProcessImpl.start");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean connect(MACAddress dstMac, UUID dstService) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("connect");
        newCall.addMACAddressParameter(dstMac);
        newCall.addUUIDParameter(dstService);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: CustomBluetoothProcessImpl.connect");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean stop() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("stop");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: CustomBluetoothProcessImpl.stop");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean isStarted() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isStarted");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: CustomBluetoothProcessImpl.isStarted");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public UUID getServiceUuid() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getServiceUuid");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (UUID)returnMessage.getObjectValue();
    }

    @Override
    public MACAddress getDstMac() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDstMac");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (MACAddress)returnMessage.getObjectValue();
    }

    @Override
    public UUID getDstServiceUuid() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDstServiceUuid");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (UUID)returnMessage.getObjectValue();
    }
}

