/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.IPV6Address;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.DNSClient;
import com.cisco.pt.ipc.sim.impl.ProcessImpl;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.util.ArrayList;
import java.util.List;

public class DNSClientImpl
extends ProcessImpl
implements DNSClient {
    public DNSClientImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public boolean addIpAddress(String hostname, IPAddress ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addIpAddress");
        newCall.addStringParameter(hostname);
        newCall.addIPAddressParameter(ipAddress);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSClientImpl.addIpAddress");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void removeIpAddress(String hostname) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeIpAddress");
        newCall.addStringParameter(hostname);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void removeIp(String hostname, IPAddress ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeIp");
        newCall.addStringParameter(hostname);
        newCall.addIPAddressParameter(ipAddress);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isValidName(String hostname) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isValidName");
        newCall.addStringParameter(hostname);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSClientImpl.isValidName");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setServerIp(IPAddress ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setServerIp");
        newCall.addIPAddressParameter(ipAddress);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public IPAddress getServerIp() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getServerIp");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPAddress)returnMessage.getObjectValue();
    }

    @Override
    public IPV6Address getServerIpv6() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getServerIpv6");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPV6Address)returnMessage.getObjectValue();
    }

    @Override
    public void setServerIpv6(IPV6Address ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setServerIpv6");
        newCall.addIPV6AddressParameter(ipAddress);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void setEnabled(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setEnabled");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isEnabled() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isEnabled");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSClientImpl.isEnabled");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public int getStrToIpCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getStrToIpCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSClientImpl.getStrToIpCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public String getHostAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getHostAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public boolean isHostNameExisted(String hostname) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isHostNameExisted");
        newCall.addStringParameter(hostname);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSClientImpl.isHostNameExisted");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean isIpExisted(String hostname, IPAddress ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isIpExisted");
        newCall.addStringParameter(hostname);
        newCall.addIPAddressParameter(ipAddress);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSClientImpl.isIpExisted");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public List<IPAddress> getIpOfHost(String hostname) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getIpOfHost");
        newCall.addStringParameter(hostname);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<IPAddress> answer = new ArrayList<IPAddress>();
        for (Object o : rawList) {
            answer.add((IPAddress)o);
        }
        return answer;
    }
}

