/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.FrameInstance;
import com.cisco.pt.ipc.sim.NFExporter;
import com.cisco.pt.ipc.sim.Port;
import com.cisco.pt.ipc.sim.impl.ProcessImpl;
import com.cisco.pt.ipc.sim.pdu.NFTemplate;
import com.cisco.pt.ptmp.PacketTracerSession;

public class NFExporterImpl
extends ProcessImpl
implements NFExporter {
    public NFExporterImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public NFTemplate getTemplateById(int id) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getTemplateById");
        newCall.addIntParameter(id);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (NFTemplate)returnMessage.getObjectValue();
    }

    @Override
    public NFTemplate getTemplateByRecordName(String recordName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getTemplateByRecordName");
        newCall.addStringParameter(recordName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (NFTemplate)returnMessage.getObjectValue();
    }

    @Override
    public boolean removeTemplate(int templateId) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeTemplate");
        newCall.addIntParameter(templateId);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: NFExporterImpl.removeTemplate");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setExporterName(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setExporterName");
        newCall.addStringParameter(name);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getExporterName() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getExporterName");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void setExporterVersion(int version) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setExporterVersion");
        newCall.addIntParameter(version);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getExporterVersion() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getExporterVersion");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: NFExporterImpl.getExporterVersion");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public long getDeviceUpTime() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDeviceUpTime");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: NFExporterImpl.getDeviceUpTime");
        }
        return returnMessage.getLongValue();
    }

    @Override
    public boolean isFullyConfigured() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isFullyConfigured");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: NFExporterImpl.isFullyConfigured");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setSrcPort(String port) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setSrcPort");
        newCall.addStringParameter(port);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public Port getSrcPort() {
        return this.getFactory().getSrcPort(this);
    }

    @Override
    public void setDestinationAddr(IPAddress ip_add) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDestinationAddr");
        newCall.addIPAddressParameter(ip_add);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public IPAddress getDestinationAddr() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDestinationAddr");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPAddress)returnMessage.getObjectValue();
    }

    @Override
    public void setDestinationUdpPort(int port) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDestinationUdpPort");
        newCall.addIntParameter(port);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getDestinationUdpPort() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDestinationUdpPort");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: NFExporterImpl.getDestinationUdpPort");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public void addMonitor(String monitorName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addMonitor");
        newCall.addStringParameter(monitorName);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void removeMontior(String monitorName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeMontior");
        newCall.addStringParameter(monitorName);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public FrameInstance createFrameInstance() {
        return this.getFactory().createFrameInstance(this);
    }
}

