/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.MACAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.PortViolation;
import com.cisco.pt.ipc.sim.Port;
import com.cisco.pt.ipc.sim.PortSecurity;
import com.cisco.pt.ipc.sim.impl.ProcessImpl;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.util.Pair;

public class PortSecurityImpl
extends ProcessImpl
implements PortSecurity {
    public PortSecurityImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public boolean isEnabled() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isEnabled");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: PortSecurityImpl.isEnabled");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setEnabled(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setEnabled");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean setMaxMacNumber(int max) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setMaxMacNumber");
        newCall.addIntParameter(max);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: PortSecurityImpl.setMaxMacNumber");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public int getMaxMacNumber() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getMaxMacNumber");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: PortSecurityImpl.getMaxMacNumber");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getTotalMac() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getTotalMac");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: PortSecurityImpl.getTotalMac");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getViolationCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getViolationCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: PortSecurityImpl.getViolationCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public Pair<MACAddress, Integer> getLastSourceMacVlan() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getLastSourceMacVlan");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        Pair rawPair = (Pair)returnMessage.getObjectValue();
        Pair<MACAddress, Integer> answer = new Pair<MACAddress, Integer>((MACAddress)rawPair.getFirst(), (Integer)rawPair.getSecond());
        return answer;
    }

    @Override
    public void setViolationMode(PortViolation type) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setViolationMode");
        newCall.addIntParameter(type.getIntValue());
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean addSecureMacEntry(MACAddress macAddress, boolean isSticky) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addSecureMacEntry");
        newCall.addMACAddressParameter(macAddress);
        newCall.addBoolParameter(isSticky);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: PortSecurityImpl.addSecureMacEntry");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeSecureMacEntry(MACAddress macAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeSecureMacEntry");
        newCall.addMACAddressParameter(macAddress);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: PortSecurityImpl.removeSecureMacEntry");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public int getSecureMacCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSecureMacCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: PortSecurityImpl.getSecureMacCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public boolean secureMacExist(MACAddress macAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("secureMacExist");
        newCall.addMACAddressParameter(macAddress);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: PortSecurityImpl.secureMacExist");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public Port getPort() {
        return this.getFactory().getPort(this);
    }

    @Override
    public boolean isStickyOn() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isStickyOn");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: PortSecurityImpl.isStickyOn");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setStickyflag(boolean isSticky) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setStickyflag");
        newCall.addBoolParameter(isSticky);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }
}

