/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipcutil;

import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.HTTPResponseType;
import com.cisco.pt.ipc.events.HTTPClientEvent;
import com.cisco.pt.ipc.events.HTTPClientEventListener;
import com.cisco.pt.ipc.events.IPCEventManager;
import com.cisco.pt.ipc.sim.Device;
import com.cisco.pt.ipc.sim.HTTPClient;
import com.cisco.pt.ipc.sim.Network;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpUtil {
    private static Log logger = LogFactory.getLog(HttpUtil.class);
    private IPCFactory ipcFacto;
    private IPCEventManager eventMgr;
    private boolean result;
    private String pageContent;
    private boolean done;
    private final Object lock = new Object();

    public HttpUtil(IPCFactory ipcFactory, IPCEventManager eventManager) {
        this.ipcFacto = ipcFactory;
        this.eventMgr = eventManager;
    }

    public String getPageContent() {
        return this.pageContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRequest(String deviceName, String url) {
        this.result = false;
        this.pageContent = "";
        this.done = false;
        boolean listenerAdded = false;
        HTTPClientEventListener clientListener = new HTTPClientEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(HTTPClientEvent evt) {
                if (evt instanceof HTTPClientEvent.OnDone) {
                    HTTPClientEvent.OnDone onDone = (HTTPClientEvent.OnDone)evt;
                    HttpUtil.this.result = onDone.responseType == HTTPResponseType.HTTP_OK;
                    Object object = HttpUtil.this.lock;
                    synchronized (object) {
                        HttpUtil.this.done = true;
                        HttpUtil.this.lock.notifyAll();
                    }
                }
            }
        };
        try {
            Network network = this.ipcFacto.network(this.ipcFacto.getIPC());
            Device device = network.getDevice(deviceName);
            HTTPClient httpClient = (HTTPClient)device.getProcess("HttpClient");
            this.eventMgr.getHTTPClientEvents().addListener(clientListener, httpClient);
            listenerAdded = true;
            httpClient.go(url);
            Object object = this.lock;
            synchronized (object) {
                while (!this.done) {
                    this.lock.wait();
                }
            }
            this.pageContent = httpClient.getLastPageContent();
        }
        catch (Exception e) {
            logger.warn((Object)("Error sending HTTP request: " + e.getMessage()));
        }
        finally {
            try {
                if (listenerAdded) {
                    this.eventMgr.getHTTPClientEvents().removeListener(clientListener);
                }
            }
            catch (IOException iOException) {}
        }
        return this.result;
    }
}

