/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.mu;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.PtmpBuffer;
import com.cisco.pt.impl.UUIDImpl;
import com.cisco.pt.mu.MultiUserMessage;
import com.cisco.pt.mu.PTSaveInfo;
import java.util.ArrayList;

public class MUSaveNetRespMessage
extends MultiUserMessage {
    public UUID saveReqId = UUIDImpl.makeRandom();
    public UUID requestorId = UUIDImpl.makeRandom();
    public int saveOrder = 0;
    public String clusterId = "";
    public ArrayList<UUID> fullySaved = new ArrayList();
    public ArrayList<PTSaveInfo> partiallySaved = new ArrayList();
    public String savedNet = "";

    public MUSaveNetRespMessage() {
        super.setType(PTMP_TYPE_MUSAVENETRESP);
    }

    public static MUSaveNetRespMessage getMessage(EncodedBuffer buffer) {
        MUSaveNetRespMessage msg = new MUSaveNetRespMessage();
        msg.saveReqId = buffer.getUUID();
        msg.requestorId = buffer.getUUID();
        msg.saveOrder = buffer.getInt();
        msg.clusterId = buffer.getString();
        int fullLen = buffer.getInt();
        for (int i = 0; i < fullLen; ++i) {
            msg.fullySaved.set(i, buffer.getUUID());
        }
        int partLen = buffer.getInt();
        for (int j = 0; j < partLen; ++j) {
            UUID ptid = buffer.getUUID();
            String clusterId = buffer.getString();
            int depthLeft = buffer.getInt();
            msg.partiallySaved.set(j, new PTSaveInfo(ptid, clusterId, depthLeft));
        }
        msg.savedNet = buffer.getString();
        return msg;
    }

    public void encodeTypeAndPayload(PtmpBuffer buffer) {
        buffer.putInt(super.getType());
        buffer.putUUID(this.saveReqId);
        buffer.putUUID(this.requestorId);
        buffer.putInt(this.saveOrder);
        buffer.putString(this.clusterId);
        buffer.putInt(this.fullySaved.size());
        for (int i = 0; i < this.fullySaved.size(); ++i) {
            buffer.putUUID(this.fullySaved.get(i));
        }
        buffer.putInt(this.partiallySaved.size());
        for (int j = 0; j < this.partiallySaved.size(); ++j) {
            buffer.putUUID(this.partiallySaved.get((int)j).ptid);
            buffer.putString(this.partiallySaved.get((int)j).clusterId);
            buffer.putInt(this.partiallySaved.get((int)j).depthLeft);
        }
        buffer.putString(this.savedNet);
        buffer.flip();
    }

    @Override
    public String toString() {
        String str = new String();
        return str;
    }
}

