/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.impl;

import com.cisco.pt.impl.OptionsManager;
import com.cisco.pt.ptmp.ConnectionNegotiationProperties;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.ptmp.PacketTracerSessionFactory;
import com.cisco.pt.ptmp.impl.PacketTracerSessionImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PacketTracerSessionFactoryImpl
implements PacketTracerSessionFactory {
    protected static Log logger = LogFactory.getLog(PacketTracerSessionFactoryImpl.class);
    protected static PacketTracerSessionFactory instance;
    protected List<PacketTracerSession> openSessions;

    protected PacketTracerSessionFactoryImpl() {
    }

    public static PacketTracerSessionFactory getInstance() {
        if (instance == null) {
            instance = new PacketTracerSessionFactoryImpl();
        }
        return instance;
    }

    @Override
    public void close() throws IOException {
        if (this.openSessions != null && !this.openSessions.isEmpty()) {
            for (PacketTracerSession ptSession : this.openSessions) {
                ptSession.close();
            }
        }
    }

    @Override
    public PacketTracerSession openSession(String host, int port, ConnectionNegotiationProperties connectionNegotiationProperties) throws IOException {
        PacketTracerSessionImpl packetTracerSession = new PacketTracerSessionImpl(host, port, connectionNegotiationProperties);
        if (this.openSessions == null) {
            this.openSessions = new ArrayList<PacketTracerSession>();
        }
        this.openSessions.add(packetTracerSession);
        return packetTracerSession;
    }

    @Override
    public PacketTracerSession openSession(String host, int port) throws IOException {
        return this.openSession(host, port, OptionsManager.getInstance().getConnectOpts());
    }

    @Override
    public int openSessionCount() throws IOException {
        int count = 0;
        if (this.openSessions != null) {
            count = this.openSessions.size();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Number of open sessions: [" + count + "]"));
            }
        }
        return count;
    }
}

