/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.impl;

import com.cisco.pt.LTV;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.impl.OptionsManager;
import com.cisco.pt.ipc.events.IPCEventManager;
import com.cisco.pt.ptmp.ConnectionNegotiationProperties;
import com.cisco.pt.ptmp.LTVNotifier;
import com.cisco.pt.ptmp.PacketTracerConnection;
import com.cisco.pt.ptmp.PacketTracerReadWorker;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.ptmp.Pipeline;
import com.cisco.pt.ptmp.impl.PacketTracerConnectionImpl;
import com.cisco.pt.ptmp.impl.PacketTracerReadWorkerImpl;
import com.cisco.pt.ptmp.impl.PipelineImpl;
import com.cisco.pt.ptmp.task.AuthenticationTask;
import com.cisco.pt.ptmp.task.ConnectionNegotiationTask;
import com.cisco.pt.ptmp.task.DisconnectTask;
import com.cisco.pt.ptmp.task.KeepAliveExpireNotifier;
import com.cisco.pt.ptmp.task.KeepAliveTask;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PacketTracerSessionImpl
implements PacketTracerSession {
    private static Log logger = LogFactory.getLog(PacketTracerSessionImpl.class);
    private PacketTracerConnection packetTracerConnection;
    private Pipeline pipeline;
    private PacketTracerReadWorker readWorker;
    private IPCEventManager eventManager;
    private Timer timer;
    private long sessionID;
    protected boolean isShutdown = false;
    protected int readErrorCount = 0;
    protected KeepAliveTask keepAliveTask = null;
    private LTVNotifier notifier = null;
    private KeepAliveExpireNotifier kn = null;
    protected Object sessionStatus = STATUS_NETWORK_DISCONNECTED;
    public static final Object STATUS_NETWORK_DISCONNECTED = "Network State Disconnected";
    public static final Object STATUS_NETWORK_CONNECTED = "Network State Connected";
    public static final Object STATUS_NEGOTIATING = "Connection is being Negotiated";
    public static final Object STATUS_NEGOTIATION_SUCCESSFUL = "Connection Options Negotiation Successful";
    public static final Object STATUS_NEGOTIATION_FAILED = "Connection Options Negotiation Failed";
    public static final Object STATUS_AUTHENTICATION_FAILED = "Connection Authentication Failed";
    public static final Object STATUS_AUTHENTICATION_SUCCESSFUL = "Connection Authentication Successful";
    public static final Object STATUS_IPC_READY = "IPC Ready For Input";

    public PacketTracerSessionImpl(String host, int port) throws IOException {
        this(host, port, OptionsManager.getInstance().getConnectOpts());
    }

    public PacketTracerSessionImpl(String host, int port, ConnectionNegotiationProperties connectionNegotiationProperties) throws IOException {
        try {
            this.sessionID = System.nanoTime();
            this.packetTracerConnection = new PacketTracerConnectionImpl(host, port, connectionNegotiationProperties);
            if (!this.packetTracerConnection.connect()) {
                throw new Error("Unable to connect to Packet Tracer", this.packetTracerConnection.getCurrentStatusThrowable());
            }
            this.sessionStatus = STATUS_NETWORK_CONNECTED;
            this.sessionStatus = STATUS_NEGOTIATING;
            ConnectionNegotiationTask connectionNegotiationTask = new ConnectionNegotiationTask(this.packetTracerConnection);
            boolean negotiated = connectionNegotiationTask.negotiateConnection();
            this.sessionStatus = negotiated ? STATUS_NEGOTIATION_SUCCESSFUL : STATUS_NEGOTIATION_FAILED;
            this.packetTracerConnection.connectLowLevelReadThread();
            this.pipeline = new PipelineImpl(this.packetTracerConnection);
            AuthenticationTask authenticationTask = new AuthenticationTask(this);
            boolean success = authenticationTask.authenticate();
            if (success) {
                this.sessionStatus = STATUS_AUTHENTICATION_SUCCESSFUL;
                this.timer = new Timer(Long.toString(this.sessionID));
                if (connectionNegotiationProperties.getKeepAlivePeriod() > 0) {
                    KeepAliveTask.KEEP_ALIVE_INTERVAL = connectionNegotiationProperties.getKeepAlivePeriod() * 1000;
                    KeepAliveTask.KEEP_ALIVE_TIMEOUT = KeepAliveTask.KEEP_ALIVE_INTERVAL * 3;
                    this.keepAliveTask = new KeepAliveTask(this);
                    this.timer.schedule((TimerTask)this.keepAliveTask, connectionNegotiationProperties.getKeepAlivePeriod() * 1000, (long)(connectionNegotiationProperties.getKeepAlivePeriod() * 1000));
                }
                this.eventManager = new IPCEventManager(this);
                this.readWorker = new PacketTracerReadWorkerImpl(this, this.pipeline);
                this.readWorker.start();
                this.eventManager.start();
                this.sessionStatus = STATUS_IPC_READY;
            } else {
                this.sessionStatus = STATUS_AUTHENTICATION_FAILED;
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"Authentication failed.");
                    logger.warn((Object)"Attempting to disconnecting from Packet Tracer.");
                }
                logger.info((Object)"Closing");
                this.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        System.out.println("Framework closed by calling close");
        if (this.readWorker != null) {
            this.readWorker.shouldStop();
            this.readWorker = null;
        }
        if (this.eventManager != null) {
            this.eventManager.interrupt();
            this.eventManager = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.keepAliveTask != null) {
            this.keepAliveTask.cancel();
        }
        DisconnectTask disconnectTask = new DisconnectTask(this);
        try {
            disconnectTask.disconnect();
        }
        catch (IOException e) {
            logger.info((Object)"Failed to sending disconnect message.", (Throwable)e);
        }
        if (this.packetTracerConnection != null) {
            this.packetTracerConnection.disconnect();
            this.packetTracerConnection = null;
        }
        this.sessionStatus = STATUS_NETWORK_DISCONNECTED;
        this.isShutdown = true;
        System.out.println("closed by program");
    }

    protected void emergencyShutdown() {
        block6: {
            System.out.println("Framework closed by calling emergencyShutdown");
            try {
                this.isShutdown = true;
                if (this.readWorker != null) {
                    this.readWorker.shouldStop();
                    this.readWorker = null;
                }
                if (this.timer != null) {
                    this.timer.cancel();
                }
                if (this.keepAliveTask != null) {
                    this.keepAliveTask.cancel();
                }
                if (this.packetTracerConnection != null) {
                    this.packetTracerConnection.disconnect();
                    this.packetTracerConnection = null;
                }
                this.sessionStatus = STATUS_NETWORK_DISCONNECTED;
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)t;
            }
        }
    }

    @Override
    public boolean readWorkerError(Throwable t) {
        ++this.readErrorCount;
        System.out.println("ReadWorkerError++ " + this.readErrorCount);
        boolean connectionOpen = false;
        try {
            connectionOpen = this.packetTracerConnection.isOpen();
        }
        catch (Throwable t2) {
            logger.error((Object)t2.toString());
            if (t2 instanceof ThreadDeath) {
                throw (ThreadDeath)t2;
            }
            connectionOpen = false;
        }
        if (!connectionOpen || this.readErrorCount > 10) {
            System.out.println("Emergency Shutdown commencing caused by " + (connectionOpen ? "connectionOpen " : String.valueOf(this.readErrorCount)));
            this.readWorker.shouldStop();
            this.emergencyShutdown();
            return false;
        }
        return true;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public IPCEventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public PacketTracerConnection connection() {
        return this.packetTracerConnection;
    }

    @Override
    public Pipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public Timer timer() {
        return this.timer;
    }

    @Override
    public boolean isConnected() {
        return this.packetTracerConnection.isConnected();
    }

    @Override
    public void write(LTV tlv) throws IOException {
        this.pipeline.write(tlv);
    }

    @Override
    public LTV writeRead(LTV tlv) throws IOException {
        if (tlv.hasResponse()) {
            if (this.readWorker == null) {
                throw new Error("Attempt to send an LTV with a non-blocking response before readWorker initialized; LTV = " + tlv);
            }
            this.readWorker.registerRequest(tlv);
            this.pipeline.write(tlv);
            return this.readWorker.getResponse(tlv);
        }
        if (this.readWorker != null) {
            throw new Error("Attempt to send an LTV with a blocking response after readWorker initialized; LTV = " + tlv);
        }
        this.pipeline.write(tlv);
        try {
            return this.pipeline.read();
        }
        catch (InterruptedException e) {
            throw new IOException("Pipeline read was interrupted");
        }
    }

    @Override
    public void handleEvent(LTV event) {
        this.eventManager.processEvent((IPCEventLTV)event);
    }

    @Override
    public void handleMuMessage(LTV msg) {
    }

    @Override
    public KeepAliveTask getKeepAliveTask() {
        return this.keepAliveTask;
    }

    @Override
    public void handleKeepAlive(LTV msg) {
        this.keepAliveTask.receivedKeepAlive();
    }

    @Override
    public void handleLTV(LTV msg) {
        if (this.notifier != null) {
            this.notifier.notify(msg);
        }
    }

    @Override
    public void setNotifier(LTVNotifier n) {
        this.notifier = n;
    }

    @Override
    public LTVNotifier getNotifier() {
        return this.notifier;
    }

    @Override
    public boolean isIpcReady() {
        return this.sessionStatus == STATUS_IPC_READY;
    }

    @Override
    public Object getSessionStatus() {
        return this.sessionStatus;
    }

    @Override
    public boolean isMuReady() {
        return false;
    }

    @Override
    public void handleTimeout() {
        if (this.kn != null) {
            this.kn.notifyExpire();
        }
    }

    @Override
    public void setTimeoutNotifier(KeepAliveExpireNotifier n) {
        this.kn = n;
    }

    @Override
    public KeepAliveExpireNotifier getTimeoutNotifier() {
        return this.kn;
    }
}

