/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.LTV;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.AuthChallengeLTV;
import com.cisco.pt.impl.AuthRequestLTV;
import com.cisco.pt.impl.AuthResponseLTV;
import com.cisco.pt.impl.AuthStatusLTV;
import com.cisco.pt.impl.BooleanValue;
import com.cisco.pt.impl.DisconnectLTV;
import com.cisco.pt.impl.IPCErrorLTV;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.impl.IPCResponseFactory;
import com.cisco.pt.impl.KeepAliveLTV;
import com.cisco.pt.impl.LTVImpl;
import com.cisco.pt.impl.StringValue;
import com.cisco.pt.mu.MUConInMessage;
import com.cisco.pt.mu.MUConOutMessage;
import com.cisco.pt.mu.MULinkUpdMessage;
import com.cisco.pt.mu.MULinkUpdStatusMessage;
import com.cisco.pt.mu.MUNameUpdMessage;
import com.cisco.pt.mu.MUNegotiationMessage;
import com.cisco.pt.mu.MUPDUMessage;
import com.cisco.pt.mu.MUPortAdvMessage;
import com.cisco.pt.mu.MUSaveNetReqMessage;
import com.cisco.pt.mu.MUSaveNetRespMessage;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LTVFactory {
    private static Log logger = LogFactory.getLog(LTVFactory.class);

    public static LTV createLTV(EncodedBuffer encBuffer) {
        LTVImpl ltv = null;
        if (encBuffer.remaining() <= 0) {
            return null;
        }
        int type = encBuffer.getInt();
        switch (type) {
            case 0: {
                break;
            }
            case 2: {
                String payload = encBuffer.getString();
                ltv = new AuthRequestLTV(new StringValue(payload));
                break;
            }
            case 3: {
                String payload = encBuffer.getString();
                ltv = new AuthChallengeLTV(new StringValue(payload));
                break;
            }
            case 4: {
                String applicationID = encBuffer.getString();
                String md5crypt = encBuffer.getString();
                ltv = new AuthResponseLTV(applicationID, md5crypt);
                break;
            }
            case 5: {
                boolean status = encBuffer.getBool();
                ltv = new AuthStatusLTV(new BooleanValue(status));
                break;
            }
            case 6: {
                ltv = new KeepAliveLTV();
                break;
            }
            case 102: {
                ltv = IPCResponseFactory.parseIPCResponseLTV(encBuffer);
                break;
            }
            case 101: {
                int messageId = encBuffer.getInt();
                String errorSource = encBuffer.getString();
                String errorMessage = encBuffer.getString();
                ltv = new IPCErrorLTV(messageId, errorSource, errorMessage);
                break;
            }
            case 103: {
                int eventId = encBuffer.getInt();
                String className = encBuffer.getString();
                UUID uuid = encBuffer.getUUID();
                String eventName = encBuffer.getString();
                List<Object> eventParameters = IPCResponseFactory.getParameterList(encBuffer);
                ltv = new IPCEventLTV(className, uuid, eventName, eventParameters);
                break;
            }
            case 7: {
                ltv = new DisconnectLTV();
                break;
            }
            case 200: {
                ltv = MUNegotiationMessage.getMessage(encBuffer);
                break;
            }
            case 201: {
                ltv = MUNegotiationMessage.getMessage(encBuffer);
                break;
            }
            case 202: {
                ltv = MUPortAdvMessage.getMessage(encBuffer);
                break;
            }
            case 203: {
                ltv = MULinkUpdMessage.getMessage(encBuffer);
                break;
            }
            case 204: {
                ltv = MULinkUpdStatusMessage.getMessage(encBuffer);
                break;
            }
            case 205: {
                ltv = MUPDUMessage.getMessage(encBuffer);
                break;
            }
            case 206: {
                ltv = MUSaveNetReqMessage.getMessage(encBuffer);
                break;
            }
            case 207: {
                ltv = MUSaveNetRespMessage.getMessage(encBuffer);
                break;
            }
            case 208: {
                ltv = MUConInMessage.getMessage(encBuffer);
                break;
            }
            case 209: {
                ltv = MUConOutMessage.getMessage(encBuffer);
                break;
            }
            case 210: {
                ltv = MUNameUpdMessage.getMessage(encBuffer);
                break;
            }
            default: {
                String payload = new String(encBuffer.getRawBytes());
                logger.error((Object)("Unrecognized message type: " + type + "\n\tMessage Body = " + payload.replace('\u0000', '_')));
            }
        }
        if (ltv != null) {
            ltv.setType(type);
        }
        return ltv;
    }
}

