/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.ARPProcessEvent;
import com.cisco.pt.ipc.events.ARPProcessEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.ARPProcess;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ARPProcessEventRegistry
extends IPCEventRegistry {
    protected Set<ARPProcessEventListener> globalListeners = new HashSet<ARPProcessEventListener>();
    protected Map<String, Set<ARPProcessEventListener>> specificObjectListeners = new HashMap<String, Set<ARPProcessEventListener>>();
    private static Log logger = LogFactory.getLog(ARPProcessEventRegistry.class);

    public ARPProcessEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "ArpProcess";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        ARPProcessEvent evt = null;
        if (eventName.equalsIgnoreCase("arpEntryAdded")) {
            evt = new ARPProcessEvent.ArpEntryAdded(event);
        } else if (eventName.equalsIgnoreCase("arpEntryRemoved")) {
            evt = new ARPProcessEvent.ArpEntryRemoved(event);
        } else if (eventName.equalsIgnoreCase("foundTakingMyIp")) {
            evt = new ARPProcessEvent.FoundTakingMyIp(event);
        } else if (eventName.equalsIgnoreCase("foundMyIpTaken")) {
            evt = new ARPProcessEvent.FoundMyIpTaken(event);
        } else if (eventName.equalsIgnoreCase("closeTableEvent")) {
            evt = new ARPProcessEvent.CloseTableEvent(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (ARPProcessEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<ARPProcessEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (ARPProcessEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(ARPProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("arpEntryAdded");
                this.register("arpEntryRemoved");
                this.register("foundTakingMyIp");
                this.register("foundMyIpTaken");
                this.register("closeTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(ARPProcessEventListener listener, ARPProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<ARPProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<ARPProcessEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "arpEntryAdded");
                this.register(uuid, "arpEntryRemoved");
                this.register(uuid, "foundTakingMyIp");
                this.register(uuid, "foundMyIpTaken");
                this.register(uuid, "closeTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(ARPProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("arpEntryAdded");
                this.deregister("arpEntryRemoved");
                this.deregister("foundTakingMyIp");
                this.deregister("foundMyIpTaken");
                this.deregister("closeTableEvent");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(ARPProcessEventListener listener, ARPProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<ARPProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "arpEntryAdded");
            this.deregister(uuid, "arpEntryRemoved");
            this.deregister(uuid, "foundTakingMyIp");
            this.deregister(uuid, "foundMyIpTaken");
            this.deregister(uuid, "closeTableEvent");
            specificListeners.remove(listener);
        }
    }

    public void addListener(ARPProcessEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(ARPProcessEventListener listener, ARPProcess objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(ARPProcessEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(ARPProcessEventListener listener, ARPProcess objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

