/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.ActivityNetworkType;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class ActivityFileEvent
extends IPCEvent {
    public EventType type;

    public ActivityFileEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        PERCENTAGE_COMPLETE_CHANGED,
        ACTIVITY_RESET,
        NETWORK_SWITCHED,
        NETWORK_FILE_CLOSING;

    }

    public static class NetworkFileClosing
    extends ActivityFileEvent {
        public NetworkFileClosing(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.NETWORK_FILE_CLOSING;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class NetworkSwitched
    extends ActivityFileEvent {
        public ActivityNetworkType networkType;

        public NetworkSwitched(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.NETWORK_SWITCHED;
            this.networkType = ActivityNetworkType.fromIntValue((Integer)ltv.getEventParameters().get(0));
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnetworkType = " + (Object)((Object)this.networkType);
        }
    }

    public static class ActivityReset
    extends ActivityFileEvent {
        public ActivityReset(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ACTIVITY_RESET;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class PercentageCompleteChanged
    extends ActivityFileEvent {
        public int oldPercent;
        public int newPercent;

        public PercentageCompleteChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.PERCENTAGE_COMPLETE_CHANGED;
            this.oldPercent = (Integer)ltv.getEventParameters().get(0);
            this.newPercent = (Integer)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\toldPercent = " + this.oldPercent + "\n\tnewPercent = " + this.newPercent;
        }
    }
}

