/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.ActivityFileEvent;
import com.cisco.pt.ipc.events.ActivityFileEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.system.ActivityFile;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActivityFileEventRegistry
extends IPCEventRegistry {
    protected Set<ActivityFileEventListener> globalListeners = new HashSet<ActivityFileEventListener>();
    protected Map<String, Set<ActivityFileEventListener>> specificObjectListeners = new HashMap<String, Set<ActivityFileEventListener>>();
    private static Log logger = LogFactory.getLog(ActivityFileEventRegistry.class);

    public ActivityFileEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "ActivityFile";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        ActivityFileEvent evt = null;
        if (eventName.equalsIgnoreCase("percentageCompleteChanged")) {
            evt = new ActivityFileEvent.PercentageCompleteChanged(event);
        } else if (eventName.equalsIgnoreCase("activityReset")) {
            evt = new ActivityFileEvent.ActivityReset(event);
        } else if (eventName.equalsIgnoreCase("networkSwitched")) {
            evt = new ActivityFileEvent.NetworkSwitched(event);
        } else if (eventName.equalsIgnoreCase("networkFileClosing")) {
            evt = new ActivityFileEvent.NetworkFileClosing(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (ActivityFileEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<ActivityFileEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (ActivityFileEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(ActivityFileEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("percentageCompleteChanged");
                this.register("activityReset");
                this.register("networkSwitched");
                this.register("networkFileClosing");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(ActivityFileEventListener listener, ActivityFile objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<ActivityFileEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<ActivityFileEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "percentageCompleteChanged");
                this.register(uuid, "activityReset");
                this.register(uuid, "networkSwitched");
                this.register(uuid, "networkFileClosing");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(ActivityFileEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("percentageCompleteChanged");
                this.deregister("activityReset");
                this.deregister("networkSwitched");
                this.deregister("networkFileClosing");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(ActivityFileEventListener listener, ActivityFile objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<ActivityFileEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "percentageCompleteChanged");
            this.deregister(uuid, "activityReset");
            this.deregister(uuid, "networkSwitched");
            this.deregister(uuid, "networkFileClosing");
            specificListeners.remove(listener);
        }
    }

    public void addListener(ActivityFileEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(ActivityFileEventListener listener, ActivityFile objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(ActivityFileEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(ActivityFileEventListener listener, ActivityFile objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

