/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.BluetoothManagerEvent;
import com.cisco.pt.ipc.events.BluetoothManagerEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.BluetoothManager;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BluetoothManagerEventRegistry
extends IPCEventRegistry {
    protected Set<BluetoothManagerEventListener> globalListeners = new HashSet<BluetoothManagerEventListener>();
    protected Map<String, Set<BluetoothManagerEventListener>> specificObjectListeners = new HashMap<String, Set<BluetoothManagerEventListener>>();
    private static Log logger = LogFactory.getLog(BluetoothManagerEventRegistry.class);

    public BluetoothManagerEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "BluetoothManager";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        BluetoothManagerEvent evt = null;
        if (eventName.equalsIgnoreCase("deviceDiscovered")) {
            evt = new BluetoothManagerEvent.DeviceDiscovered(event);
        } else if (eventName.equalsIgnoreCase("devicePaired")) {
            evt = new BluetoothManagerEvent.DevicePaired(event);
        } else if (eventName.equalsIgnoreCase("deviceUnpaired")) {
            evt = new BluetoothManagerEvent.DeviceUnpaired(event);
        } else if (eventName.equalsIgnoreCase("deviceConnected")) {
            evt = new BluetoothManagerEvent.DeviceConnected(event);
        } else if (eventName.equalsIgnoreCase("deviceDisconnected")) {
            evt = new BluetoothManagerEvent.DeviceDisconnected(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (BluetoothManagerEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<BluetoothManagerEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (BluetoothManagerEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(BluetoothManagerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("deviceDiscovered");
                this.register("devicePaired");
                this.register("deviceUnpaired");
                this.register("deviceConnected");
                this.register("deviceDisconnected");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(BluetoothManagerEventListener listener, BluetoothManager objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<BluetoothManagerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<BluetoothManagerEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "deviceDiscovered");
                this.register(uuid, "devicePaired");
                this.register(uuid, "deviceUnpaired");
                this.register(uuid, "deviceConnected");
                this.register(uuid, "deviceDisconnected");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(BluetoothManagerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("deviceDiscovered");
                this.deregister("devicePaired");
                this.deregister("deviceUnpaired");
                this.deregister("deviceConnected");
                this.deregister("deviceDisconnected");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(BluetoothManagerEventListener listener, BluetoothManager objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<BluetoothManagerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "deviceDiscovered");
            this.deregister(uuid, "devicePaired");
            this.deregister(uuid, "deviceUnpaired");
            this.deregister(uuid, "deviceConnected");
            this.deregister(uuid, "deviceDisconnected");
            specificListeners.remove(listener);
        }
    }

    public void addListener(BluetoothManagerEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(BluetoothManagerEventListener listener, BluetoothManager objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(BluetoothManagerEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(BluetoothManagerEventListener listener, BluetoothManager objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

