/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.DslSignalingEvent;
import com.cisco.pt.ipc.events.DslSignalingEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.DslSignaling;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DslSignalingEventRegistry
extends IPCEventRegistry {
    protected Set<DslSignalingEventListener> globalListeners = new HashSet<DslSignalingEventListener>();
    protected Map<String, Set<DslSignalingEventListener>> specificObjectListeners = new HashMap<String, Set<DslSignalingEventListener>>();
    private static Log logger = LogFactory.getLog(DslSignalingEventRegistry.class);

    public DslSignalingEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "DslSignaling";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        DslSignalingEvent.UpdateTableEvent evt = null;
        if (!eventName.equalsIgnoreCase("updateTableEvent")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new DslSignalingEvent.UpdateTableEvent(event);
        for (DslSignalingEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<DslSignalingEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (DslSignalingEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(DslSignalingEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("updateTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(DslSignalingEventListener listener, DslSignaling objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DslSignalingEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<DslSignalingEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "updateTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(DslSignalingEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("updateTableEvent");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(DslSignalingEventListener listener, DslSignaling objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DslSignalingEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "updateTableEvent");
            specificListeners.remove(listener);
        }
    }

    public void addListener(DslSignalingEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(DslSignalingEventListener listener, DslSignaling objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(DslSignalingEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(DslSignalingEventListener listener, DslSignaling objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

