/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.FrontEndBridgeEvent;
import com.cisco.pt.ipc.events.FrontEndBridgeEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.ui.FrontEndBridge;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FrontEndBridgeEventRegistry
extends IPCEventRegistry {
    protected Set<FrontEndBridgeEventListener> globalListeners = new HashSet<FrontEndBridgeEventListener>();
    protected Map<String, Set<FrontEndBridgeEventListener>> specificObjectListeners = new HashMap<String, Set<FrontEndBridgeEventListener>>();
    private static Log logger = LogFactory.getLog(FrontEndBridgeEventRegistry.class);

    public FrontEndBridgeEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "FrontEndBridge";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        FrontEndBridgeEvent.MessageForFrontEnd evt = null;
        if (!eventName.equalsIgnoreCase("messageForFrontEnd")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new FrontEndBridgeEvent.MessageForFrontEnd(event);
        for (FrontEndBridgeEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<FrontEndBridgeEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (FrontEndBridgeEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(FrontEndBridgeEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("messageForFrontEnd");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(FrontEndBridgeEventListener listener, FrontEndBridge objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<FrontEndBridgeEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<FrontEndBridgeEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "messageForFrontEnd");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(FrontEndBridgeEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("messageForFrontEnd");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(FrontEndBridgeEventListener listener, FrontEndBridge objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<FrontEndBridgeEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "messageForFrontEnd");
            specificListeners.remove(listener);
        }
    }

    public void addListener(FrontEndBridgeEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(FrontEndBridgeEventListener listener, FrontEndBridge objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(FrontEndBridgeEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(FrontEndBridgeEventListener listener, FrontEndBridge objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

