/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.HTTPResponseType;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class HTTPClientEvent
extends IPCEvent {
    public EventType type;

    public HTTPClientEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        ON_START,
        ON_DONE;

    }

    public static class OnDone
    extends HTTPClientEvent {
        public String url;
        public IPAddress serverIp;
        public HTTPResponseType responseType;
        public String content;

        public OnDone(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ON_DONE;
            this.url = (String)ltv.getEventParameters().get(0);
            this.serverIp = (IPAddress)ltv.getEventParameters().get(1);
            this.responseType = HTTPResponseType.fromIntValue((Integer)ltv.getEventParameters().get(2));
            this.content = (String)ltv.getEventParameters().get(3);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\turl = " + this.url + "\n\tserverIp = " + this.serverIp + "\n\tresponseType = " + (Object)((Object)this.responseType) + "\n\tcontent = " + this.content;
        }
    }

    public static class OnStart
    extends HTTPClientEvent {
        public String url;

        public OnStart(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ON_START;
            this.url = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\turl = " + this.url;
        }
    }
}

