/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.InstructionDlgEvent;
import com.cisco.pt.ipc.events.InstructionDlgEventListener;
import com.cisco.pt.ipc.ui.InstructionDlg;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstructionDlgEventRegistry
extends IPCEventRegistry {
    protected Set<InstructionDlgEventListener> globalListeners = new HashSet<InstructionDlgEventListener>();
    protected Map<String, Set<InstructionDlgEventListener>> specificObjectListeners = new HashMap<String, Set<InstructionDlgEventListener>>();
    private static Log logger = LogFactory.getLog(InstructionDlgEventRegistry.class);

    public InstructionDlgEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "InstructionDlg";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        InstructionDlgEvent evt = null;
        if (eventName.equalsIgnoreCase("dockChanged")) {
            evt = new InstructionDlgEvent.DockChanged(event);
        } else if (eventName.equalsIgnoreCase("countdownExpired")) {
            evt = new InstructionDlgEvent.CountdownExpired(event);
        } else if (eventName.equalsIgnoreCase("buttonClicked")) {
            evt = new InstructionDlgEvent.ButtonClicked(event);
        } else if (eventName.equalsIgnoreCase("sliderValueChanged")) {
            evt = new InstructionDlgEvent.SliderValueChanged(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (InstructionDlgEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<InstructionDlgEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (InstructionDlgEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(InstructionDlgEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("dockChanged");
                this.register("countdownExpired");
                this.register("buttonClicked");
                this.register("sliderValueChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(InstructionDlgEventListener listener, InstructionDlg objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<InstructionDlgEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<InstructionDlgEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "dockChanged");
                this.register(uuid, "countdownExpired");
                this.register(uuid, "buttonClicked");
                this.register(uuid, "sliderValueChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(InstructionDlgEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("dockChanged");
                this.deregister("countdownExpired");
                this.deregister("buttonClicked");
                this.deregister("sliderValueChanged");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(InstructionDlgEventListener listener, InstructionDlg objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<InstructionDlgEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "dockChanged");
            this.deregister(uuid, "countdownExpired");
            this.deregister(uuid, "buttonClicked");
            this.deregister(uuid, "sliderValueChanged");
            specificListeners.remove(listener);
        }
    }

    public void addListener(InstructionDlgEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(InstructionDlgEventListener listener, InstructionDlg objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(InstructionDlgEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(InstructionDlgEventListener listener, InstructionDlg objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

