/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.IoEComponentEvent;
import com.cisco.pt.ipc.events.IoEComponentEventListener;
import com.cisco.pt.ipc.sim.IoEComponent;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IoEComponentEventRegistry
extends IPCEventRegistry {
    protected Set<IoEComponentEventListener> globalListeners = new HashSet<IoEComponentEventListener>();
    protected Map<String, Set<IoEComponentEventListener>> specificObjectListeners = new HashMap<String, Set<IoEComponentEventListener>>();
    private static Log logger = LogFactory.getLog(IoEComponentEventRegistry.class);

    public IoEComponentEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "IoEComponent";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        IoEComponentEvent.ValueChanged evt = null;
        if (!eventName.equalsIgnoreCase("valueChanged")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new IoEComponentEvent.ValueChanged(event);
        for (IoEComponentEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<IoEComponentEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (IoEComponentEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(IoEComponentEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("valueChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(IoEComponentEventListener listener, IoEComponent objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<IoEComponentEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<IoEComponentEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "valueChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(IoEComponentEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("valueChanged");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(IoEComponentEventListener listener, IoEComponent objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<IoEComponentEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "valueChanged");
            specificListeners.remove(listener);
        }
    }

    public void addListener(IoEComponentEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(IoEComponentEventListener listener, IoEComponent objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(IoEComponentEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(IoEComponentEventListener listener, IoEComponent objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

