/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.IPV6Address;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class NdProcessEvent
extends IPCEvent {
    public EventType type;

    public NdProcessEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        AUTO_CONFIG_FAILED,
        AUTO_CONFIG_SUCCEED;

    }

    public static class AutoConfigSucceed
    extends NdProcessEvent {
        public String deviceName;
        public String portName;
        public IPV6Address newip;
        public int prefix;

        public AutoConfigSucceed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.AUTO_CONFIG_SUCCEED;
            this.deviceName = (String)ltv.getEventParameters().get(0);
            this.portName = (String)ltv.getEventParameters().get(1);
            this.newip = (IPV6Address)ltv.getEventParameters().get(2);
            this.prefix = (Integer)ltv.getEventParameters().get(3);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tdeviceName = " + this.deviceName + "\n\tportName = " + this.portName + "\n\tnewip = " + this.newip + "\n\tprefix = " + this.prefix;
        }
    }

    public static class AutoConfigFailed
    extends NdProcessEvent {
        public String deviceName;
        public String portName;

        public AutoConfigFailed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.AUTO_CONFIG_FAILED;
            this.deviceName = (String)ltv.getEventParameters().get(0);
            this.portName = (String)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tdeviceName = " + this.deviceName + "\n\tportName = " + this.portName;
        }
    }
}

