/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.PLSwitchEvent;
import com.cisco.pt.ipc.events.PLSwitchEventListener;
import com.cisco.pt.ipc.ui.PLSwitch;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PLSwitchEventRegistry
extends IPCEventRegistry {
    protected Set<PLSwitchEventListener> globalListeners = new HashSet<PLSwitchEventListener>();
    protected Map<String, Set<PLSwitchEventListener>> specificObjectListeners = new HashMap<String, Set<PLSwitchEventListener>>();
    private static Log logger = LogFactory.getLog(PLSwitchEventRegistry.class);

    public PLSwitchEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "PLSwitch";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        PLSwitchEvent.ModeSwitched evt = null;
        if (!eventName.equalsIgnoreCase("modeSwitched")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new PLSwitchEvent.ModeSwitched(event);
        for (PLSwitchEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<PLSwitchEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (PLSwitchEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(PLSwitchEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("modeSwitched");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(PLSwitchEventListener listener, PLSwitch objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PLSwitchEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<PLSwitchEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "modeSwitched");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(PLSwitchEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("modeSwitched");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(PLSwitchEventListener listener, PLSwitch objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PLSwitchEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "modeSwitched");
            specificListeners.remove(listener);
        }
    }

    public void addListener(PLSwitchEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(PLSwitchEventListener listener, PLSwitch objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(PLSwitchEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(PLSwitchEventListener listener, PLSwitch objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

