/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.PhysicalObjectEvent;
import com.cisco.pt.ipc.events.PhysicalObjectEventListener;
import com.cisco.pt.ipc.ui.PhysicalObject;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhysicalObjectEventRegistry
extends IPCEventRegistry {
    protected Set<PhysicalObjectEventListener> globalListeners = new HashSet<PhysicalObjectEventListener>();
    protected Map<String, Set<PhysicalObjectEventListener>> specificObjectListeners = new HashMap<String, Set<PhysicalObjectEventListener>>();
    private static Log logger = LogFactory.getLog(PhysicalObjectEventRegistry.class);

    public PhysicalObjectEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "PhysicalObject";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        PhysicalObjectEvent.DeviceMoved evt = null;
        if (!eventName.equalsIgnoreCase("deviceMoved")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new PhysicalObjectEvent.DeviceMoved(event);
        for (PhysicalObjectEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<PhysicalObjectEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (PhysicalObjectEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(PhysicalObjectEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("deviceMoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(PhysicalObjectEventListener listener, PhysicalObject objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PhysicalObjectEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<PhysicalObjectEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "deviceMoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(PhysicalObjectEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("deviceMoved");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(PhysicalObjectEventListener listener, PhysicalObject objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PhysicalObjectEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "deviceMoved");
            specificListeners.remove(listener);
        }
    }

    public void addListener(PhysicalObjectEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(PhysicalObjectEventListener listener, PhysicalObject objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(PhysicalObjectEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(PhysicalObjectEventListener listener, PhysicalObject objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

