/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class RoutingProcessEvent
extends IPCEvent {
    public EventType type;

    public RoutingProcessEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        ROUTE_ADDED,
        ROUTE_REMOVED,
        NETWORK_ADDED,
        NETWORK_REMOVED;

    }

    public static class NetworkRemoved
    extends RoutingProcessEvent {
        public IPAddress network;
        public IPAddress subnetMask;

        public NetworkRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.NETWORK_REMOVED;
            this.network = (IPAddress)ltv.getEventParameters().get(0);
            this.subnetMask = (IPAddress)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tsubnetMask = " + this.subnetMask;
        }
    }

    public static class NetworkAdded
    extends RoutingProcessEvent {
        public IPAddress network;
        public IPAddress subnetMask;

        public NetworkAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.NETWORK_ADDED;
            this.network = (IPAddress)ltv.getEventParameters().get(0);
            this.subnetMask = (IPAddress)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tsubnetMask = " + this.subnetMask;
        }
    }

    public static class RouteRemoved
    extends RoutingProcessEvent {
        public IPAddress network;
        public IPAddress mask;
        public int metric;
        public int distance;
        public IPAddress nexthop;
        public String portName;
        public String protocolCode;

        public RouteRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ROUTE_REMOVED;
            this.network = (IPAddress)ltv.getEventParameters().get(0);
            this.mask = (IPAddress)ltv.getEventParameters().get(1);
            this.metric = (Integer)ltv.getEventParameters().get(2);
            this.distance = (Integer)ltv.getEventParameters().get(3);
            this.nexthop = (IPAddress)ltv.getEventParameters().get(4);
            this.portName = (String)ltv.getEventParameters().get(5);
            this.protocolCode = (String)ltv.getEventParameters().get(6);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tmask = " + this.mask + "\n\tmetric = " + this.metric + "\n\tdistance = " + this.distance + "\n\tnexthop = " + this.nexthop + "\n\tportName = " + this.portName + "\n\tprotocolCode = " + this.protocolCode;
        }
    }

    public static class RouteAdded
    extends RoutingProcessEvent {
        public IPAddress network;
        public IPAddress mask;
        public int metric;
        public int distance;
        public IPAddress nexthop;
        public String portName;
        public String protocolCode;

        public RouteAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ROUTE_ADDED;
            this.network = (IPAddress)ltv.getEventParameters().get(0);
            this.mask = (IPAddress)ltv.getEventParameters().get(1);
            this.metric = (Integer)ltv.getEventParameters().get(2);
            this.distance = (Integer)ltv.getEventParameters().get(3);
            this.nexthop = (IPAddress)ltv.getEventParameters().get(4);
            this.portName = (String)ltv.getEventParameters().get(5);
            this.protocolCode = (String)ltv.getEventParameters().get(6);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tmask = " + this.mask + "\n\tmetric = " + this.metric + "\n\tdistance = " + this.distance + "\n\tnexthop = " + this.nexthop + "\n\tportName = " + this.portName + "\n\tprotocolCode = " + this.protocolCode;
        }
    }
}

