/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.RoutingProcessEvent;
import com.cisco.pt.ipc.events.RoutingProcessEventListener;
import com.cisco.pt.ipc.sim.RoutingProcess;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RoutingProcessEventRegistry
extends IPCEventRegistry {
    protected Set<RoutingProcessEventListener> globalListeners = new HashSet<RoutingProcessEventListener>();
    protected Map<String, Set<RoutingProcessEventListener>> specificObjectListeners = new HashMap<String, Set<RoutingProcessEventListener>>();
    private static Log logger = LogFactory.getLog(RoutingProcessEventRegistry.class);

    public RoutingProcessEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "RoutingProcess";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        RoutingProcessEvent evt = null;
        if (eventName.equalsIgnoreCase("routeAdded")) {
            evt = new RoutingProcessEvent.RouteAdded(event);
        } else if (eventName.equalsIgnoreCase("routeRemoved")) {
            evt = new RoutingProcessEvent.RouteRemoved(event);
        } else if (eventName.equalsIgnoreCase("networkAdded")) {
            evt = new RoutingProcessEvent.NetworkAdded(event);
        } else if (eventName.equalsIgnoreCase("networkRemoved")) {
            evt = new RoutingProcessEvent.NetworkRemoved(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (RoutingProcessEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<RoutingProcessEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (RoutingProcessEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(RoutingProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("routeAdded");
                this.register("routeRemoved");
                this.register("networkAdded");
                this.register("networkRemoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(RoutingProcessEventListener listener, RoutingProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<RoutingProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<RoutingProcessEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "routeAdded");
                this.register(uuid, "routeRemoved");
                this.register(uuid, "networkAdded");
                this.register(uuid, "networkRemoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(RoutingProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("routeAdded");
                this.deregister("routeRemoved");
                this.deregister("networkAdded");
                this.deregister("networkRemoved");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(RoutingProcessEventListener listener, RoutingProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<RoutingProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "routeAdded");
            this.deregister(uuid, "routeRemoved");
            this.deregister(uuid, "networkAdded");
            this.deregister(uuid, "networkRemoved");
            specificListeners.remove(listener);
        }
    }

    public void addListener(RoutingProcessEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(RoutingProcessEventListener listener, RoutingProcess objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(RoutingProcessEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(RoutingProcessEventListener listener, RoutingProcess objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

