/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.SyslogServerEvent;
import com.cisco.pt.ipc.events.SyslogServerEventListener;
import com.cisco.pt.ipc.sim.SyslogServer;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SyslogServerEventRegistry
extends IPCEventRegistry {
    protected Set<SyslogServerEventListener> globalListeners = new HashSet<SyslogServerEventListener>();
    protected Map<String, Set<SyslogServerEventListener>> specificObjectListeners = new HashMap<String, Set<SyslogServerEventListener>>();
    private static Log logger = LogFactory.getLog(SyslogServerEventRegistry.class);

    public SyslogServerEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "SyslogServer";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        SyslogServerEvent.SyslogEntryAdded evt = null;
        if (!eventName.equalsIgnoreCase("SyslogEntryAdded")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new SyslogServerEvent.SyslogEntryAdded(event);
        for (SyslogServerEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<SyslogServerEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (SyslogServerEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(SyslogServerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("SyslogEntryAdded");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(SyslogServerEventListener listener, SyslogServer objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<SyslogServerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<SyslogServerEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "SyslogEntryAdded");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(SyslogServerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("SyslogEntryAdded");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(SyslogServerEventListener listener, SyslogServer objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<SyslogServerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "SyslogEntryAdded");
            specificListeners.remove(listener);
        }
    }

    public void addListener(SyslogServerEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(SyslogServerEventListener listener, SyslogServer objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(SyslogServerEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(SyslogServerEventListener listener, SyslogServer objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

