/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.CommandStatus;
import com.cisco.pt.ipc.enums.DirectiveCommand;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class TerminalLineEvent
extends IPCEvent {
    public EventType type;

    public TerminalLineEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        TERMINAL_UPDATED,
        MORE_DISPLAYED,
        OUTPUT_WRITTEN,
        CURSOR_POSITION_CHANGED,
        DIRECTIVE_SENT,
        COMMAND_STARTED,
        COMMAND_ENDED,
        COMMAND_AUTO_COMPLETED,
        MODE_CHANGED,
        PROMPT_CHANGED,
        COMMAND_SELECTED_FROM_HISTORY;

    }

    public static class CommandSelectedFromHistory
    extends TerminalLineEvent {
        public String historyCommand;

        public CommandSelectedFromHistory(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.COMMAND_SELECTED_FROM_HISTORY;
            this.historyCommand = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\thistoryCommand = " + this.historyCommand;
        }
    }

    public static class PromptChanged
    extends TerminalLineEvent {
        public String newPrompt;

        public PromptChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.PROMPT_CHANGED;
            this.newPrompt = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnewPrompt = " + this.newPrompt;
        }
    }

    public static class ModeChanged
    extends TerminalLineEvent {
        public String newMode;
        public String newModeArg;
        public String newPrompt;

        public ModeChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.MODE_CHANGED;
            this.newMode = (String)ltv.getEventParameters().get(0);
            this.newModeArg = (String)ltv.getEventParameters().get(1);
            this.newPrompt = (String)ltv.getEventParameters().get(2);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnewMode = " + this.newMode + "\n\tnewModeArg = " + this.newModeArg + "\n\tnewPrompt = " + this.newPrompt;
        }
    }

    public static class CommandAutoCompleted
    extends TerminalLineEvent {
        public String inputCommand;
        public String completeCommand;

        public CommandAutoCompleted(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.COMMAND_AUTO_COMPLETED;
            this.inputCommand = (String)ltv.getEventParameters().get(0);
            this.completeCommand = (String)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tinputCommand = " + this.inputCommand + "\n\tcompleteCommand = " + this.completeCommand;
        }
    }

    public static class CommandEnded
    extends TerminalLineEvent {
        public String inputCommand;
        public CommandStatus status;

        public CommandEnded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.COMMAND_ENDED;
            this.inputCommand = (String)ltv.getEventParameters().get(0);
            this.status = CommandStatus.fromIntValue((Integer)ltv.getEventParameters().get(1));
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tinputCommand = " + this.inputCommand + "\n\tstatus = " + (Object)((Object)this.status);
        }
    }

    public static class CommandStarted
    extends TerminalLineEvent {
        public String inputCommand;
        public String completeCommand;
        public String processedCommand;
        public String inputMode;

        public CommandStarted(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.COMMAND_STARTED;
            this.inputCommand = (String)ltv.getEventParameters().get(0);
            this.completeCommand = (String)ltv.getEventParameters().get(1);
            this.processedCommand = (String)ltv.getEventParameters().get(2);
            this.inputMode = (String)ltv.getEventParameters().get(3);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tinputCommand = " + this.inputCommand + "\n\tcompleteCommand = " + this.completeCommand + "\n\tprocessedCommand = " + this.processedCommand + "\n\tinputMode = " + this.inputMode;
        }
    }

    public static class DirectiveSent
    extends TerminalLineEvent {
        public DirectiveCommand directiveCommand;
        public int cursorPositionFromEnd;

        public DirectiveSent(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DIRECTIVE_SENT;
            this.directiveCommand = DirectiveCommand.fromIntValue((Integer)ltv.getEventParameters().get(0));
            this.cursorPositionFromEnd = (Integer)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tdirectiveCommand = " + (Object)((Object)this.directiveCommand) + "\n\tcursorPositionFromEnd = " + this.cursorPositionFromEnd;
        }
    }

    public static class CursorPositionChanged
    extends TerminalLineEvent {
        public int positionFromEnd;

        public CursorPositionChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CURSOR_POSITION_CHANGED;
            this.positionFromEnd = (Integer)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tpositionFromEnd = " + this.positionFromEnd;
        }
    }

    public static class OutputWritten
    extends TerminalLineEvent {
        public String newOutput;
        public Boolean isDebug;
        public int cursorPositionFromEnd;

        public OutputWritten(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.OUTPUT_WRITTEN;
            this.newOutput = (String)ltv.getEventParameters().get(0);
            this.isDebug = (Boolean)ltv.getEventParameters().get(1);
            this.cursorPositionFromEnd = (Integer)ltv.getEventParameters().get(2);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tnewOutput = " + this.newOutput + "\n\tisDebug = " + this.isDebug + "\n\tcursorPositionFromEnd = " + this.cursorPositionFromEnd;
        }
    }

    public static class MoreDisplayed
    extends TerminalLineEvent {
        public MoreDisplayed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.MORE_DISPLAYED;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class TerminalUpdated
    extends TerminalLineEvent {
        public String updatedStr;

        public TerminalUpdated(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.TERMINAL_UPDATED;
            this.updatedStr = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tupdatedStr = " + this.updatedStr;
        }
    }
}

