/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.TerminalLineEvent;
import com.cisco.pt.ipc.events.TerminalLineEventListener;
import com.cisco.pt.ipc.sim.TerminalLine;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TerminalLineEventRegistry
extends IPCEventRegistry {
    protected Set<TerminalLineEventListener> globalListeners = new HashSet<TerminalLineEventListener>();
    protected Map<String, Set<TerminalLineEventListener>> specificObjectListeners = new HashMap<String, Set<TerminalLineEventListener>>();
    private static Log logger = LogFactory.getLog(TerminalLineEventRegistry.class);

    public TerminalLineEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "TerminalLine";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        TerminalLineEvent evt = null;
        if (eventName.equalsIgnoreCase("terminalUpdated")) {
            evt = new TerminalLineEvent.TerminalUpdated(event);
        } else if (eventName.equalsIgnoreCase("moreDisplayed")) {
            evt = new TerminalLineEvent.MoreDisplayed(event);
        } else if (eventName.equalsIgnoreCase("outputWritten")) {
            evt = new TerminalLineEvent.OutputWritten(event);
        } else if (eventName.equalsIgnoreCase("cursorPositionChanged")) {
            evt = new TerminalLineEvent.CursorPositionChanged(event);
        } else if (eventName.equalsIgnoreCase("directiveSent")) {
            evt = new TerminalLineEvent.DirectiveSent(event);
        } else if (eventName.equalsIgnoreCase("commandStarted")) {
            evt = new TerminalLineEvent.CommandStarted(event);
        } else if (eventName.equalsIgnoreCase("commandEnded")) {
            evt = new TerminalLineEvent.CommandEnded(event);
        } else if (eventName.equalsIgnoreCase("commandAutoCompleted")) {
            evt = new TerminalLineEvent.CommandAutoCompleted(event);
        } else if (eventName.equalsIgnoreCase("modeChanged")) {
            evt = new TerminalLineEvent.ModeChanged(event);
        } else if (eventName.equalsIgnoreCase("promptChanged")) {
            evt = new TerminalLineEvent.PromptChanged(event);
        } else if (eventName.equalsIgnoreCase("commandSelectedFromHistory")) {
            evt = new TerminalLineEvent.CommandSelectedFromHistory(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (TerminalLineEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<TerminalLineEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (TerminalLineEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(TerminalLineEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("terminalUpdated");
                this.register("moreDisplayed");
                this.register("outputWritten");
                this.register("cursorPositionChanged");
                this.register("directiveSent");
                this.register("commandStarted");
                this.register("commandEnded");
                this.register("commandAutoCompleted");
                this.register("modeChanged");
                this.register("promptChanged");
                this.register("commandSelectedFromHistory");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(TerminalLineEventListener listener, TerminalLine objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<TerminalLineEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<TerminalLineEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "terminalUpdated");
                this.register(uuid, "moreDisplayed");
                this.register(uuid, "outputWritten");
                this.register(uuid, "cursorPositionChanged");
                this.register(uuid, "directiveSent");
                this.register(uuid, "commandStarted");
                this.register(uuid, "commandEnded");
                this.register(uuid, "commandAutoCompleted");
                this.register(uuid, "modeChanged");
                this.register(uuid, "promptChanged");
                this.register(uuid, "commandSelectedFromHistory");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(TerminalLineEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("terminalUpdated");
                this.deregister("moreDisplayed");
                this.deregister("outputWritten");
                this.deregister("cursorPositionChanged");
                this.deregister("directiveSent");
                this.deregister("commandStarted");
                this.deregister("commandEnded");
                this.deregister("commandAutoCompleted");
                this.deregister("modeChanged");
                this.deregister("promptChanged");
                this.deregister("commandSelectedFromHistory");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(TerminalLineEventListener listener, TerminalLine objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<TerminalLineEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "terminalUpdated");
            this.deregister(uuid, "moreDisplayed");
            this.deregister(uuid, "outputWritten");
            this.deregister(uuid, "cursorPositionChanged");
            this.deregister(uuid, "directiveSent");
            this.deregister(uuid, "commandStarted");
            this.deregister(uuid, "commandEnded");
            this.deregister(uuid, "commandAutoCompleted");
            this.deregister(uuid, "modeChanged");
            this.deregister(uuid, "promptChanged");
            this.deregister(uuid, "commandSelectedFromHistory");
            specificListeners.remove(listener);
        }
    }

    public void addListener(TerminalLineEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(TerminalLineEventListener listener, TerminalLine objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(TerminalLineEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(TerminalLineEventListener listener, TerminalLine objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

