/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.AcsServerType;
import com.cisco.pt.ipc.sim.AcsServerProcess;
import com.cisco.pt.ipc.sim.impl.ProcessImpl;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.util.ArrayList;
import java.util.List;

public class AcsServerProcessImpl
extends ProcessImpl
implements AcsServerProcess {
    public AcsServerProcessImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public boolean addToUserMap(String userName, String description, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addToUserMap");
        newCall.addStringParameter(userName);
        newCall.addStringParameter(description);
        newCall.addStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: AcsServerProcessImpl.addToUserMap");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void deleteFromUserMap(String userName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("deleteFromUserMap");
        newCall.addStringParameter(userName);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean addToClientMap(IPAddress hostIp, AcsServerType serverType, String name, String keyStr) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addToClientMap");
        newCall.addIPAddressParameter(hostIp);
        newCall.addIntParameter(serverType.getIntValue());
        newCall.addStringParameter(name);
        newCall.addStringParameter(keyStr);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: AcsServerProcessImpl.addToClientMap");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void deleteFromClientMap(IPAddress hostIp, AcsServerType serverType) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("deleteFromClientMap");
        newCall.addIPAddressParameter(hostIp);
        newCall.addIntParameter(serverType.getIntValue());
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void enableACSServerService(boolean status) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("enableACSServerService");
        newCall.addBoolParameter(status);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isEnabled() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isEnabled");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: AcsServerProcessImpl.isEnabled");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public List<String> getUserRecordsAsString() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getUserRecordsAsString");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<String> answer = new ArrayList<String>();
        for (Object o : rawList) {
            answer.add((String)o);
        }
        return answer;
    }

    @Override
    public List<String> getClientRecordsAsString() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getClientRecordsAsString");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<String> answer = new ArrayList<String>();
        for (Object o : rawList) {
            answer.add((String)o);
        }
        return answer;
    }

    @Override
    public void removeAllUserRecords() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeAllUserRecords");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void removeAllClientRecords() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeAllClientRecords");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }
}

