/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.DNSServerProcess;
import com.cisco.pt.ipc.sim.impl.ProcessImpl;
import com.cisco.pt.ipc.sim.pdu.DNSResourceRecord;
import com.cisco.pt.ipc.sim.pdu.DNSRrA;
import com.cisco.pt.ipc.sim.pdu.DNSRrCname;
import com.cisco.pt.ipc.sim.pdu.DNSRrNs;
import com.cisco.pt.ipc.sim.pdu.DNSRrSoa;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class DNSServerProcessImpl
extends ProcessImpl
implements DNSServerProcess {
    public DNSServerProcessImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public boolean addIpAddress(String hostname, IPAddress ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addIpAddress");
        newCall.addStringParameter(hostname);
        newCall.addIPAddressParameter(ipAddress);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.addIpAddress");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void removeIpAddress(String hostname) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeIpAddress");
        newCall.addStringParameter(hostname);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public Pair<String, IPAddress> getEntryAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getEntryAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        Pair rawPair = (Pair)returnMessage.getObjectValue();
        Pair<String, IPAddress> answer = new Pair<String, IPAddress>((String)rawPair.getFirst(), (IPAddress)rawPair.getSecond());
        return answer;
    }

    @Override
    public int getEntryCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getEntryCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.getEntryCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public boolean isValidName(String hostname) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isValidName");
        newCall.addStringParameter(hostname);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.isValidName");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setEnable(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setEnable");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isEnabled() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isEnabled");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.isEnabled");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setPortNumber(int num) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setPortNumber");
        newCall.addIntParameter(num);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getPortNumber() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getPortNumber");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.getPortNumber");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public boolean isDomainNameExisted(String domainName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isDomainNameExisted");
        newCall.addStringParameter(domainName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.isDomainNameExisted");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public IPAddress getIpAddOfDomain(String domainName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getIpAddOfDomain");
        newCall.addStringParameter(domainName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPAddress)returnMessage.getObjectValue();
    }

    @Override
    public DNSRrA getARecordWithAddress(String domainName, IPAddress address) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getARecordWithAddress");
        newCall.addStringParameter(domainName);
        newCall.addIPAddressParameter(address);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (DNSRrA)returnMessage.getObjectValue();
    }

    @Override
    public DNSRrCname getCNameRecordWithHostname(String domainName, String hostName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCNameRecordWithHostname");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(hostName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (DNSRrCname)returnMessage.getObjectValue();
    }

    @Override
    public DNSRrSoa getSOARecordWithMailbox(String domainName, String mailbox) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSOARecordWithMailbox");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(mailbox);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (DNSRrSoa)returnMessage.getObjectValue();
    }

    @Override
    public DNSRrNs getNSRecordWithServerName(String domainName, String serverName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getNSRecordWithServerName");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(serverName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (DNSRrNs)returnMessage.getObjectValue();
    }

    @Override
    public boolean addARecordToNameServerDb(String domainName, String address) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addARecordToNameServerDb");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(address);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.addARecordToNameServerDb");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean addCNAMEToNameServerDb(String domainName, String hostName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addCNAMEToNameServerDb");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(hostName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.addCNAMEToNameServerDb");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean addSOAToNameServerDb(String domainName, String serverName, String mailbox, String minTtl, String refresh, String retry, String expiry) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addSOAToNameServerDb");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(serverName);
        newCall.addStringParameter(mailbox);
        newCall.addStringParameter(minTtl);
        newCall.addStringParameter(refresh);
        newCall.addStringParameter(retry);
        newCall.addStringParameter(expiry);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.addSOAToNameServerDb");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean addNSRecordToNameServerDb(String domainName, String serverName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addNSRecordToNameServerDb");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(serverName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.addNSRecordToNameServerDb");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeARecordFromNameServerDb(String domainName, String address) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeARecordFromNameServerDb");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(address);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.removeARecordFromNameServerDb");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeCNAMEFromNameServerDb(String domainName, String hostName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeCNAMEFromNameServerDb");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(hostName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.removeCNAMEFromNameServerDb");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeSOAFromNameServerDb(String domainName, String mailbox) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeSOAFromNameServerDb");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(mailbox);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.removeSOAFromNameServerDb");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeNSRecordFromNameServerDb(String domainName, String serverName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeNSRecordFromNameServerDb");
        newCall.addStringParameter(domainName);
        newCall.addStringParameter(serverName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.removeNSRecordFromNameServerDb");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public int getSizeOfNameServerDb() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSizeOfNameServerDb");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.getSizeOfNameServerDb");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public DNSResourceRecord getRrFromNameServerDbAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getRrFromNameServerDbAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (DNSResourceRecord)returnMessage.getObjectValue();
    }

    @Override
    public List<DNSResourceRecord> getMatchingRRsFromCache(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getMatchingRRsFromCache");
        newCall.addStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<DNSResourceRecord> answer = new ArrayList<DNSResourceRecord>();
        for (Object o : rawList) {
            answer.add((DNSResourceRecord)o);
        }
        return answer;
    }
}

