/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.IPV6Address;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.IPV6AddressType;
import com.cisco.pt.ipc.sim.HostPort;
import com.cisco.pt.ipc.sim.IPV6AddressConfig;
import com.cisco.pt.ipc.sim.impl.PortImpl;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.util.ArrayList;
import java.util.List;

public class HostPortImpl
extends PortImpl
implements HostPort {
    public HostPortImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public void setIpSubnetMask(IPAddress newIpAddress, IPAddress newMask) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setIpSubnetMask");
        newCall.addIPAddressParameter(newIpAddress);
        newCall.addIPAddressParameter(newMask);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void setDefaultArpTimeout() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDefaultArpTimeout");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void setDhcpClientFlag(boolean bFlag) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDhcpClientFlag");
        newCall.addBoolParameter(bFlag);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isDhcpClientOn() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isDhcpClientOn");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.isDhcpClientOn");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public IPAddress getIpAddress() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getIpAddress");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPAddress)returnMessage.getObjectValue();
    }

    @Override
    public IPAddress getSubnetMask() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSubnetMask");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPAddress)returnMessage.getObjectValue();
    }

    @Override
    public void setIpv6Enabled(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setIpv6Enabled");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isIpv6Enabled() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isIpv6Enabled");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.isIpv6Enabled");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setIpv6AddressAutoConfig(boolean bAutoConfig) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setIpv6AddressAutoConfig");
        newCall.addBoolParameter(bAutoConfig);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isIpv6AddressAutoConfig() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isIpv6AddressAutoConfig");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.isIpv6AddressAutoConfig");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean isSetToDhcpv6() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isSetToDhcpv6");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.isSetToDhcpv6");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setIpv6LinkLocal(IPV6Address ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setIpv6LinkLocal");
        newCall.addIPV6AddressParameter(ipAddress);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public IPV6Address getIpv6LinkLocal() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getIpv6LinkLocal");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPV6Address)returnMessage.getObjectValue();
    }

    @Override
    public boolean addIpv6Address(IPV6Address ipAddress, int prefix, IPV6AddressType type, boolean bAllowDup) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addIpv6Address");
        newCall.addIPV6AddressParameter(ipAddress);
        newCall.addIntParameter(prefix);
        newCall.addIntParameter(type.getIntValue());
        newCall.addBoolParameter(bAllowDup);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.addIpv6Address");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeIpv6Address(IPV6Address ipAddress, int prefix, IPV6AddressType type) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeIpv6Address");
        newCall.addIPV6AddressParameter(ipAddress);
        newCall.addIntParameter(prefix);
        newCall.addIntParameter(type.getIntValue());
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.removeIpv6Address");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void removeAllIpv6Addresses() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeAllIpv6Addresses");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean hasIpv6Address(IPV6Address ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("hasIpv6Address");
        newCall.addIPV6AddressParameter(ipAddress);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.hasIpv6Address");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public IPV6AddressConfig getIpv6Address(IPV6Address ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getIpv6Address");
        newCall.addIPV6AddressParameter(ipAddress);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPV6AddressConfig)returnMessage.getObjectValue();
    }

    @Override
    public IPV6Address getUnicastIpv6Address() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getUnicastIpv6Address");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPV6Address)returnMessage.getObjectValue();
    }

    @Override
    public int getUnicastIpv6Prefix() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getUnicastIpv6Prefix");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.getUnicastIpv6Prefix");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public List<IPV6AddressConfig> getIpv6Addresses() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getIpv6Addresses");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<IPV6AddressConfig> answer = new ArrayList<IPV6AddressConfig>();
        for (Object o : rawList) {
            answer.add((IPV6AddressConfig)o);
        }
        return answer;
    }

    @Override
    public boolean isInIpv6Multicast(IPV6Address ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isInIpv6Multicast");
        newCall.addIPV6AddressParameter(ipAddress);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.isInIpv6Multicast");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public List<IPV6Address> getIpv6Multicast() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getIpv6Multicast");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<IPV6Address> answer = new ArrayList<IPV6Address>();
        for (Object o : rawList) {
            answer.add((IPV6Address)o);
        }
        return answer;
    }

    @Override
    public void setMtu(int mtu) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setMtu");
        newCall.addIntParameter(mtu);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getMtu() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getMtu");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.getMtu");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public void setIpMtu(int mtu) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setIpMtu");
        newCall.addIntParameter(mtu);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getIpMtu() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getIpMtu");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.getIpMtu");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public void setIpv6Mtu(int mtu) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setIpv6Mtu");
        newCall.addIntParameter(mtu);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getIpv6Mtu() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getIpv6Mtu");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.getIpv6Mtu");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public void setDefaultGateway(IPAddress gateway) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDefaultGateway");
        newCall.addIPAddressParameter(gateway);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void setDnsServerIp(IPAddress gateway) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDnsServerIp");
        newCall.addIPAddressParameter(gateway);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void setv6ServerIp(IPV6Address gateway) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setv6ServerIp");
        newCall.addIPV6AddressParameter(gateway);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void setv6DefaultGateway(IPV6Address gateway) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setv6DefaultGateway");
        newCall.addIPV6AddressParameter(gateway);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isInboundFirewallOn() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isInboundFirewallOn");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.isInboundFirewallOn");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setInboundFirewallService(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setInboundFirewallService");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isInboundIpv6FirewallOn() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isInboundIpv6FirewallOn");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: HostPortImpl.isInboundIpv6FirewallOn");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setInboundIpv6FirewallService(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setInboundIpv6FirewallService");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }
}

