/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.MACAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.MACSwitch;
import com.cisco.pt.ipc.sim.StaticMac;
import com.cisco.pt.ipc.sim.impl.ProcessImpl;
import com.cisco.pt.ptmp.PacketTracerSession;

public class MACSwitchImpl
extends ProcessImpl
implements MACSwitch {
    public MACSwitchImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public boolean addStaticMac(MACAddress macAddress, int vlanNumber, String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addStaticMac");
        newCall.addMACAddressParameter(macAddress);
        newCall.addIntParameter(vlanNumber);
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: MACSwitchImpl.addStaticMac");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeStaticMac(MACAddress macAddress, int vlanNumber, String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeStaticMac");
        newCall.addMACAddressParameter(macAddress);
        newCall.addIntParameter(vlanNumber);
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: MACSwitchImpl.removeStaticMac");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public int getStaticMacCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getStaticMacCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: MACSwitchImpl.getStaticMacCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public StaticMac getGlobalMacAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getGlobalMacAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (StaticMac)returnMessage.getObjectValue();
    }

    @Override
    public boolean portExistedInStatic(String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("portExistedInStatic");
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: MACSwitchImpl.portExistedInStatic");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean isEntryExisted(MACAddress macAddress, int vlanNumber, String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isEntryExisted");
        newCall.addMACAddressParameter(macAddress);
        newCall.addIntParameter(vlanNumber);
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: MACSwitchImpl.isEntryExisted");
        }
        return returnMessage.getBoolValue();
    }
}

