/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPV6Address;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.DHCPv6Option;
import com.cisco.pt.ipc.sim.pdu.DHCPv6OptionIAAddress;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DHCPv6OptionIAAddressImpl
extends DHCPv6OptionImpl
implements DHCPv6OptionIAAddress {
    protected IPV6Address address;
    protected int preferredLifeTime;
    protected int validLifeTime;
    protected List<DHCPv6Option> IAAddrOptions;

    public DHCPv6OptionIAAddressImpl() {
        this.fieldNames.add("DHCPv6OptionIAAddressImpl_address");
        this.fieldNames.add("DHCPv6OptionIAAddressImpl_preferredLifeTime");
        this.fieldNames.add("DHCPv6OptionIAAddressImpl_validLifeTime");
        this.fieldNames.add("DHCPv6OptionIAAddressImpl_IAAddrOptions");
        this.signalType = "Dhcpv6OptionIAAddress";
    }

    @Override
    public IPV6Address getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(IPV6Address address) {
        this.address = address;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("DHCPv6OptionIAAddressImpl_address")) continue;
            this.fieldTable.set(i, new Pair<String, IPV6Address>("DHCPv6OptionIAAddressImpl_address", address));
            return;
        }
    }

    @Override
    public int getPreferredLifeTime() {
        return this.preferredLifeTime;
    }

    @Override
    public void setPreferredLifeTime(int preferredLifeTime) {
        this.preferredLifeTime = preferredLifeTime;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("DHCPv6OptionIAAddressImpl_preferredLifeTime")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("DHCPv6OptionIAAddressImpl_preferredLifeTime", preferredLifeTime));
            return;
        }
    }

    @Override
    public int getValidLifeTime() {
        return this.validLifeTime;
    }

    @Override
    public void setValidLifeTime(int validLifeTime) {
        this.validLifeTime = validLifeTime;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("DHCPv6OptionIAAddressImpl_validLifeTime")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("DHCPv6OptionIAAddressImpl_validLifeTime", validLifeTime));
            return;
        }
    }

    @Override
    public List<DHCPv6Option> getIAAddrOptions() {
        return this.IAAddrOptions;
    }

    @Override
    public void setIAAddrOptions(List<DHCPv6Option> IAAddrOptions) {
        this.IAAddrOptions = IAAddrOptions;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("DHCPv6OptionIAAddressImpl_IAAddrOptions")) continue;
            this.fieldTable.set(i, new Pair<String, List<DHCPv6Option>>("DHCPv6OptionIAAddressImpl_IAAddrOptions", IAAddrOptions));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("DHCPv6OptionIAAddressImpl_address")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("DHCPv6OptionIAAddressImpl_preferredLifeTime")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("DHCPv6OptionIAAddressImpl_validLifeTime")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("DHCPv6OptionIAAddressImpl_IAAddrOptions")) {
            return PtmpTypeValue.DATA;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, IPV6Address>("DHCPv6OptionIAAddressImpl_address", this.address));
        this.fieldTable.add(new Pair<String, Integer>("DHCPv6OptionIAAddressImpl_preferredLifeTime", this.preferredLifeTime));
        this.fieldTable.add(new Pair<String, Integer>("DHCPv6OptionIAAddressImpl_validLifeTime", this.validLifeTime));
        this.fieldTable.add(new Pair<String, List<DHCPv6Option>>("DHCPv6OptionIAAddressImpl_IAAddrOptions", this.IAAddrOptions));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.address = this.readIPV6Address(buffer);
        this.preferredLifeTime = this.readInt(buffer);
        this.validLifeTime = this.readInt(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.IAAddrOptions = new ArrayList<DHCPv6Option>();
        for (Object o : tempList1) {
            this.IAAddrOptions.add((DHCPv6Option)o);
        }
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.address = this.pduReadIPV6Address(buffer);
        this.preferredLifeTime = this.pduReadInt(buffer);
        this.validLifeTime = this.pduReadInt(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)16);
        this.IAAddrOptions = new ArrayList<DHCPv6Option>();
        for (Object o : tempList1) {
            this.IAAddrOptions.add((DHCPv6Option)o);
        }
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putIPV6Address(this.address);
        buffer.putInt(this.preferredLifeTime);
        buffer.putInt(this.validLifeTime);
        buffer.putInt(this.IAAddrOptions.size());
        for (DHCPv6Option item : this.IAAddrOptions) {
            item.encodeTypeAndPayload(buffer);
        }
    }
}

