/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPAddress;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.OSPFv3HelloPacket;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFPacketImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OSPFv3HelloPacketImpl
extends OSPFPacketImpl
implements OSPFv3HelloPacket {
    protected int interfaceId;
    protected Byte priority;
    protected int optionV3;
    protected Short helloInterval;
    protected Short deadInterval;
    protected IPAddress designatedRouter;
    protected IPAddress backupDesignatedRouter;
    protected List<IPAddress> neighbors;

    public OSPFv3HelloPacketImpl() {
        this.fieldNames.add("OSPFv3HelloPacketImpl_interfaceId");
        this.fieldNames.add("OSPFv3HelloPacketImpl_priority");
        this.fieldNames.add("OSPFv3HelloPacketImpl_optionV3");
        this.fieldNames.add("OSPFv3HelloPacketImpl_helloInterval");
        this.fieldNames.add("OSPFv3HelloPacketImpl_deadInterval");
        this.fieldNames.add("OSPFv3HelloPacketImpl_designatedRouter");
        this.fieldNames.add("OSPFv3HelloPacketImpl_backupDesignatedRouter");
        this.fieldNames.add("OSPFv3HelloPacketImpl_neighbors");
        this.signalType = "Ospfv3HelloPacket";
    }

    @Override
    public int getInterfaceId() {
        return this.interfaceId;
    }

    @Override
    public void setInterfaceId(int interfaceId) {
        this.interfaceId = interfaceId;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv3HelloPacketImpl_interfaceId")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("OSPFv3HelloPacketImpl_interfaceId", interfaceId));
            return;
        }
    }

    @Override
    public Byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(Byte priority) {
        this.priority = priority;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv3HelloPacketImpl_priority")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("OSPFv3HelloPacketImpl_priority", priority));
            return;
        }
    }

    @Override
    public int getOptionV3() {
        return this.optionV3;
    }

    @Override
    public void setOptionV3(int optionV3) {
        this.optionV3 = optionV3;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv3HelloPacketImpl_optionV3")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("OSPFv3HelloPacketImpl_optionV3", optionV3));
            return;
        }
    }

    @Override
    public Short getHelloInterval() {
        return this.helloInterval;
    }

    @Override
    public void setHelloInterval(Short helloInterval) {
        this.helloInterval = helloInterval;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv3HelloPacketImpl_helloInterval")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("OSPFv3HelloPacketImpl_helloInterval", helloInterval));
            return;
        }
    }

    @Override
    public Short getDeadInterval() {
        return this.deadInterval;
    }

    @Override
    public void setDeadInterval(Short deadInterval) {
        this.deadInterval = deadInterval;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv3HelloPacketImpl_deadInterval")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("OSPFv3HelloPacketImpl_deadInterval", deadInterval));
            return;
        }
    }

    @Override
    public IPAddress getDesignatedRouter() {
        return this.designatedRouter;
    }

    @Override
    public void setDesignatedRouter(IPAddress designatedRouter) {
        this.designatedRouter = designatedRouter;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv3HelloPacketImpl_designatedRouter")) continue;
            this.fieldTable.set(i, new Pair<String, IPAddress>("OSPFv3HelloPacketImpl_designatedRouter", designatedRouter));
            return;
        }
    }

    @Override
    public IPAddress getBackupDesignatedRouter() {
        return this.backupDesignatedRouter;
    }

    @Override
    public void setBackupDesignatedRouter(IPAddress backupDesignatedRouter) {
        this.backupDesignatedRouter = backupDesignatedRouter;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv3HelloPacketImpl_backupDesignatedRouter")) continue;
            this.fieldTable.set(i, new Pair<String, IPAddress>("OSPFv3HelloPacketImpl_backupDesignatedRouter", backupDesignatedRouter));
            return;
        }
    }

    @Override
    public List<IPAddress> getNeighbors() {
        return this.neighbors;
    }

    @Override
    public void setNeighbors(List<IPAddress> neighbors) {
        this.neighbors = neighbors;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv3HelloPacketImpl_neighbors")) continue;
            this.fieldTable.set(i, new Pair<String, List<IPAddress>>("OSPFv3HelloPacketImpl_neighbors", neighbors));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("OSPFv3HelloPacketImpl_interfaceId")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("OSPFv3HelloPacketImpl_priority")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("OSPFv3HelloPacketImpl_optionV3")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("OSPFv3HelloPacketImpl_helloInterval")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("OSPFv3HelloPacketImpl_deadInterval")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("OSPFv3HelloPacketImpl_designatedRouter")) {
            return PtmpTypeValue.IP_ADDRESS;
        }
        if (fieldName.equals("OSPFv3HelloPacketImpl_backupDesignatedRouter")) {
            return PtmpTypeValue.IP_ADDRESS;
        }
        if (fieldName.equals("OSPFv3HelloPacketImpl_neighbors")) {
            return PtmpTypeValue.DATA;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, Integer>("OSPFv3HelloPacketImpl_interfaceId", this.interfaceId));
        this.fieldTable.add(new Pair<String, Byte>("OSPFv3HelloPacketImpl_priority", this.priority));
        this.fieldTable.add(new Pair<String, Integer>("OSPFv3HelloPacketImpl_optionV3", this.optionV3));
        this.fieldTable.add(new Pair<String, Short>("OSPFv3HelloPacketImpl_helloInterval", this.helloInterval));
        this.fieldTable.add(new Pair<String, Short>("OSPFv3HelloPacketImpl_deadInterval", this.deadInterval));
        this.fieldTable.add(new Pair<String, IPAddress>("OSPFv3HelloPacketImpl_designatedRouter", this.designatedRouter));
        this.fieldTable.add(new Pair<String, IPAddress>("OSPFv3HelloPacketImpl_backupDesignatedRouter", this.backupDesignatedRouter));
        this.fieldTable.add(new Pair<String, List<IPAddress>>("OSPFv3HelloPacketImpl_neighbors", this.neighbors));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.interfaceId = this.readInt(buffer);
        this.priority = this.readByte(buffer);
        this.optionV3 = this.readInt(buffer);
        this.helloInterval = this.readShort(buffer);
        this.deadInterval = this.readShort(buffer);
        this.designatedRouter = this.readIPAddress(buffer);
        this.backupDesignatedRouter = this.readIPAddress(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.neighbors = new ArrayList<IPAddress>();
        for (Object o : tempList1) {
            this.neighbors.add((IPAddress)o);
        }
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.interfaceId = this.pduReadInt(buffer);
        this.priority = this.pduReadByte(buffer);
        this.optionV3 = this.pduReadInt(buffer);
        this.helloInterval = this.pduReadShort(buffer);
        this.deadInterval = this.pduReadShort(buffer);
        this.designatedRouter = this.pduReadIPAddress(buffer);
        this.backupDesignatedRouter = this.pduReadIPAddress(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)10);
        this.neighbors = new ArrayList<IPAddress>();
        for (Object o : tempList1) {
            this.neighbors.add((IPAddress)o);
        }
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putInt(this.interfaceId);
        buffer.putByte(this.priority);
        buffer.putInt(this.optionV3);
        buffer.putShort(this.helloInterval);
        buffer.putShort(this.deadInterval);
        buffer.putIPAddress(this.designatedRouter);
        buffer.putIPAddress(this.backupDesignatedRouter);
        buffer.putInt(this.neighbors.size());
        for (IPAddress item : this.neighbors) {
            buffer.putIPAddress(item);
        }
    }
}

