/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.TcpHeader;
import com.cisco.pt.ipc.sim.pdu.TcpOption;
import com.cisco.pt.ipc.sim.pdu.impl.SegmentHeaderImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TcpHeaderImpl
extends SegmentHeaderImpl
implements TcpHeader {
    protected int seqNumber;
    protected int ackNumber;
    protected Byte dataOffset;
    protected Byte reserved;
    protected Byte controlBits;
    protected Short windowSize;
    protected Short urgentPtr;
    protected List<TcpOption> options;
    protected List<Byte> rawOptions;
    protected int payloadSize;

    public TcpHeaderImpl() {
        this.fieldNames.add("TcpHeaderImpl_seqNumber");
        this.fieldNames.add("TcpHeaderImpl_ackNumber");
        this.fieldNames.add("TcpHeaderImpl_dataOffset");
        this.fieldNames.add("TcpHeaderImpl_reserved");
        this.fieldNames.add("TcpHeaderImpl_controlBits");
        this.fieldNames.add("TcpHeaderImpl_windowSize");
        this.fieldNames.add("TcpHeaderImpl_urgentPtr");
        this.fieldNames.add("TcpHeaderImpl_options");
        this.fieldNames.add("TcpHeaderImpl_rawOptions");
        this.fieldNames.add("TcpHeaderImpl_payloadSize");
        this.signalType = "TcpHeader";
    }

    @Override
    public int getSeqNumber() {
        return this.seqNumber;
    }

    @Override
    public void setSeqNumber(int seqNumber) {
        this.seqNumber = seqNumber;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("TcpHeaderImpl_seqNumber")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("TcpHeaderImpl_seqNumber", seqNumber));
            return;
        }
    }

    @Override
    public int getAckNumber() {
        return this.ackNumber;
    }

    @Override
    public void setAckNumber(int ackNumber) {
        this.ackNumber = ackNumber;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("TcpHeaderImpl_ackNumber")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("TcpHeaderImpl_ackNumber", ackNumber));
            return;
        }
    }

    @Override
    public Byte getDataOffset() {
        return this.dataOffset;
    }

    @Override
    public void setDataOffset(Byte dataOffset) {
        this.dataOffset = dataOffset;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("TcpHeaderImpl_dataOffset")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("TcpHeaderImpl_dataOffset", dataOffset));
            return;
        }
    }

    @Override
    public Byte getReserved() {
        return this.reserved;
    }

    @Override
    public void setReserved(Byte reserved) {
        this.reserved = reserved;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("TcpHeaderImpl_reserved")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("TcpHeaderImpl_reserved", reserved));
            return;
        }
    }

    @Override
    public Byte getControlBits() {
        return this.controlBits;
    }

    @Override
    public void setControlBits(Byte controlBits) {
        this.controlBits = controlBits;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("TcpHeaderImpl_controlBits")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("TcpHeaderImpl_controlBits", controlBits));
            return;
        }
    }

    @Override
    public Short getWindowSize() {
        return this.windowSize;
    }

    @Override
    public void setWindowSize(Short windowSize) {
        this.windowSize = windowSize;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("TcpHeaderImpl_windowSize")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("TcpHeaderImpl_windowSize", windowSize));
            return;
        }
    }

    @Override
    public Short getUrgentPtr() {
        return this.urgentPtr;
    }

    @Override
    public void setUrgentPtr(Short urgentPtr) {
        this.urgentPtr = urgentPtr;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("TcpHeaderImpl_urgentPtr")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("TcpHeaderImpl_urgentPtr", urgentPtr));
            return;
        }
    }

    @Override
    public List<TcpOption> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(List<TcpOption> options) {
        this.options = options;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("TcpHeaderImpl_options")) continue;
            this.fieldTable.set(i, new Pair<String, List<TcpOption>>("TcpHeaderImpl_options", options));
            return;
        }
    }

    @Override
    public List<Byte> getRawOptions() {
        return this.rawOptions;
    }

    @Override
    public void setRawOptions(List<Byte> rawOptions) {
        this.rawOptions = rawOptions;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("TcpHeaderImpl_rawOptions")) continue;
            this.fieldTable.set(i, new Pair<String, List<Byte>>("TcpHeaderImpl_rawOptions", rawOptions));
            return;
        }
    }

    @Override
    public int getPayloadSize() {
        return this.payloadSize;
    }

    @Override
    public void setPayloadSize(int payloadSize) {
        this.payloadSize = payloadSize;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("TcpHeaderImpl_payloadSize")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("TcpHeaderImpl_payloadSize", payloadSize));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("TcpHeaderImpl_seqNumber")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("TcpHeaderImpl_ackNumber")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("TcpHeaderImpl_dataOffset")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("TcpHeaderImpl_reserved")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("TcpHeaderImpl_controlBits")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("TcpHeaderImpl_windowSize")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("TcpHeaderImpl_urgentPtr")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("TcpHeaderImpl_options")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("TcpHeaderImpl_rawOptions")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("TcpHeaderImpl_payloadSize")) {
            return PtmpTypeValue.INT;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, Integer>("TcpHeaderImpl_seqNumber", this.seqNumber));
        this.fieldTable.add(new Pair<String, Integer>("TcpHeaderImpl_ackNumber", this.ackNumber));
        this.fieldTable.add(new Pair<String, Byte>("TcpHeaderImpl_dataOffset", this.dataOffset));
        this.fieldTable.add(new Pair<String, Byte>("TcpHeaderImpl_reserved", this.reserved));
        this.fieldTable.add(new Pair<String, Byte>("TcpHeaderImpl_controlBits", this.controlBits));
        this.fieldTable.add(new Pair<String, Short>("TcpHeaderImpl_windowSize", this.windowSize));
        this.fieldTable.add(new Pair<String, Short>("TcpHeaderImpl_urgentPtr", this.urgentPtr));
        this.fieldTable.add(new Pair<String, List<TcpOption>>("TcpHeaderImpl_options", this.options));
        this.fieldTable.add(new Pair<String, List<Byte>>("TcpHeaderImpl_rawOptions", this.rawOptions));
        this.fieldTable.add(new Pair<String, Integer>("TcpHeaderImpl_payloadSize", this.payloadSize));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.seqNumber = this.readInt(buffer);
        this.ackNumber = this.readInt(buffer);
        this.dataOffset = this.readByte(buffer);
        this.reserved = this.readByte(buffer);
        this.controlBits = this.readByte(buffer);
        this.windowSize = this.readShort(buffer);
        this.urgentPtr = this.readShort(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.options = new ArrayList<TcpOption>();
        for (Object o : tempList1) {
            this.options.add((TcpOption)o);
        }
        List<Object> tempList2 = this.readVector(buffer);
        this.rawOptions = new ArrayList<Byte>();
        for (Object o : tempList2) {
            this.rawOptions.add((Byte)o);
        }
        this.payloadSize = this.readInt(buffer);
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.seqNumber = this.pduReadInt(buffer);
        this.ackNumber = this.pduReadInt(buffer);
        this.dataOffset = this.pduReadByte(buffer);
        this.reserved = this.pduReadByte(buffer);
        this.controlBits = this.pduReadByte(buffer);
        this.windowSize = this.pduReadShort(buffer);
        this.urgentPtr = this.pduReadShort(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)16);
        this.options = new ArrayList<TcpOption>();
        for (Object o : tempList1) {
            this.options.add((TcpOption)o);
        }
        List<Object> tempList2 = this.pduReadVector(buffer, (byte)1);
        this.rawOptions = new ArrayList<Byte>();
        for (Object o : tempList2) {
            this.rawOptions.add((Byte)o);
        }
        this.payloadSize = this.pduReadInt(buffer);
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putInt(this.seqNumber);
        buffer.putInt(this.ackNumber);
        buffer.putByte(this.dataOffset);
        buffer.putByte(this.reserved);
        buffer.putByte(this.controlBits);
        buffer.putShort(this.windowSize);
        buffer.putShort(this.urgentPtr);
        buffer.putInt(this.options.size());
        for (TcpOption item : this.options) {
            item.encodeTypeAndPayload(buffer);
        }
        buffer.putByteList(this.rawOptions);
        buffer.putInt(this.payloadSize);
    }
}

