/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.ui.impl;

import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.FilePermissions;
import com.cisco.pt.ipc.impl.IPCObjectImpl;
import com.cisco.pt.ipc.ui.SystemFileManager;
import com.cisco.pt.ipc.ui.SystemFileWatcher;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.util.ArrayList;
import java.util.List;

public class SystemFileManagerImpl
extends IPCObjectImpl
implements SystemFileManager {
    public SystemFileManagerImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public String getOpenFileName(String caption, String path, String filters) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getOpenFileName");
        newCall.addQStringParameter(caption);
        newCall.addQStringParameter(path);
        newCall.addQStringParameter(filters);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public List<String> getOpenFileNames(String caption, String path, String filters) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getOpenFileNames");
        newCall.addQStringParameter(caption);
        newCall.addQStringParameter(path);
        newCall.addQStringParameter(filters);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<String> answer = new ArrayList<String>();
        for (Object o : rawList) {
            answer.add((String)o);
        }
        return answer;
    }

    @Override
    public String getSaveFileName(String caption, String path, String filters) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSaveFileName");
        newCall.addQStringParameter(caption);
        newCall.addQStringParameter(path);
        newCall.addQStringParameter(filters);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String getFileContents(String filename) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFileContents");
        newCall.addQStringParameter(filename);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String getFileBinaryContents(String filename) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFileBinaryContents");
        newCall.addQStringParameter(filename);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public boolean writeTextToFile(String filename, String contents64) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("writeTextToFile");
        newCall.addQStringParameter(filename);
        newCall.addQStringParameter(contents64);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.writeTextToFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean writePlainTextToFile(String filename, String contents) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("writePlainTextToFile");
        newCall.addQStringParameter(filename);
        newCall.addQStringParameter(contents);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.writePlainTextToFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean writeBinaryToFile(String filename, String contents64) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("writeBinaryToFile");
        newCall.addQStringParameter(filename);
        newCall.addQStringParameter(contents64);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.writeBinaryToFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public int getFileSize(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFileSize");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.getFileSize");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public String getFileCheckSum(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFileCheckSum");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public long getFileModificationTime(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFileModificationTime");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.getFileModificationTime");
        }
        return returnMessage.getLongValue();
    }

    @Override
    public FilePermissions getFilePermissions(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFilePermissions");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.getFilePermissions");
        }
        return FilePermissions.fromIntValue(returnMessage.getIntValue());
    }

    @Override
    public boolean setFilePermissions(String path, FilePermissions permissions) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setFilePermissions");
        newCall.addQStringParameter(path);
        newCall.addIntParameter(permissions.getIntValue());
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.setFilePermissions");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean copySrcFileToDestFile(String srcFile, String destFile) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("copySrcFileToDestFile");
        newCall.addQStringParameter(srcFile);
        newCall.addQStringParameter(destFile);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.copySrcFileToDestFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean moveSrcFileToDestFile(String srcFile, String destFile, boolean bReplace) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("moveSrcFileToDestFile");
        newCall.addQStringParameter(srcFile);
        newCall.addQStringParameter(destFile);
        newCall.addBoolParameter(bReplace);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.moveSrcFileToDestFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean copySrcDirectoryToDestDirectory(String srcDir, String destDir, boolean bReplace, FilePermissions permissions) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("copySrcDirectoryToDestDirectory");
        newCall.addQStringParameter(srcDir);
        newCall.addQStringParameter(destDir);
        newCall.addBoolParameter(bReplace);
        newCall.addIntParameter(permissions.getIntValue());
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.copySrcDirectoryToDestDirectory");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean moveSrcDirectoryToDestDirectory(String srcDir, String destDir, boolean bReplace) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("moveSrcDirectoryToDestDirectory");
        newCall.addQStringParameter(srcDir);
        newCall.addQStringParameter(destDir);
        newCall.addBoolParameter(bReplace);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.moveSrcDirectoryToDestDirectory");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean zipDirectory(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("zipDirectory");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.zipDirectory");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean zipDirectoryWithPassword(String path, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("zipDirectoryWithPassword");
        newCall.addQStringParameter(path);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.zipDirectoryWithPassword");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean zipDirectoryTo(String path, String dstFile) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("zipDirectoryTo");
        newCall.addQStringParameter(path);
        newCall.addQStringParameter(dstFile);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.zipDirectoryTo");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean zipDirectoryToWithPassword(String path, String dstFile, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("zipDirectoryToWithPassword");
        newCall.addQStringParameter(path);
        newCall.addQStringParameter(dstFile);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.zipDirectoryToWithPassword");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean unzipFile(String filePath) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("unzipFile");
        newCall.addQStringParameter(filePath);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.unzipFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean unzipFileWithPassword(String filePath, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("unzipFileWithPassword");
        newCall.addQStringParameter(filePath);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.unzipFileWithPassword");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean unzipFileTo(String filePath, String dstPath) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("unzipFileTo");
        newCall.addQStringParameter(filePath);
        newCall.addQStringParameter(dstPath);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.unzipFileTo");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean unzipFileToWithPassword(String filePath, String dstPath, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("unzipFileToWithPassword");
        newCall.addQStringParameter(filePath);
        newCall.addQStringParameter(dstPath);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.unzipFileToWithPassword");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public String encrypt(String data, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("encrypt");
        newCall.addQStringParameter(data);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String decrypt(String data, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("decrypt");
        newCall.addQStringParameter(data);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String encryptBinary(String data64, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("encryptBinary");
        newCall.addQStringParameter(data64);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String decryptBinary(String data64, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("decryptBinary");
        newCall.addQStringParameter(data64);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String getEncryptedFileContents(String filename, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getEncryptedFileContents");
        newCall.addQStringParameter(filename);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String getEncryptedFileBinaryContents(String filename, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getEncryptedFileBinaryContents");
        newCall.addQStringParameter(filename);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public boolean writeTextToEncryptedFile(String filename, String contents, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("writeTextToEncryptedFile");
        newCall.addQStringParameter(filename);
        newCall.addQStringParameter(contents);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.writeTextToEncryptedFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean writeBinaryToEncryptedFile(String filename, String contents64, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("writeBinaryToEncryptedFile");
        newCall.addQStringParameter(filename);
        newCall.addQStringParameter(contents64);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.writeBinaryToEncryptedFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean writeTextToEncryptedLogFile(String filename, String contents) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("writeTextToEncryptedLogFile");
        newCall.addQStringParameter(filename);
        newCall.addQStringParameter(contents);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.writeTextToEncryptedLogFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean encryptFile(String srcFile, String dstFile, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("encryptFile");
        newCall.addQStringParameter(srcFile);
        newCall.addQStringParameter(dstFile);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.encryptFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean decryptFile(String srcFile, String dstFile, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("decryptFile");
        newCall.addQStringParameter(srcFile);
        newCall.addQStringParameter(dstFile);
        newCall.addQStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.decryptFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean makeDirectory(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("makeDirectory");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.makeDirectory");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeFile(String filePath) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeFile");
        newCall.addQStringParameter(filePath);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.removeFile");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeDirectory(String dirPath) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeDirectory");
        newCall.addQStringParameter(dirPath);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.removeDirectory");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean directoryExists(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("directoryExists");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.directoryExists");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean fileExists(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("fileExists");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.fileExists");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public String convertToNativeSeparators(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("convertToNativeSeparators");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String convertFromNativeSeparators(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("convertFromNativeSeparators");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public boolean isAbsolutePath(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isAbsolutePath");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.isAbsolutePath");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean isRelativePath(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isRelativePath");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: SystemFileManagerImpl.isRelativePath");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public String getRelativePath(String path1, String path2) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getRelativePath");
        newCall.addQStringParameter(path1);
        newCall.addQStringParameter(path2);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String getAbsolutePath(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAbsolutePath");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public List<String> getFilesInDirectory(String path) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFilesInDirectory");
        newCall.addQStringParameter(path);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<String> answer = new ArrayList<String>();
        for (Object o : rawList) {
            answer.add((String)o);
        }
        return answer;
    }

    @Override
    public SystemFileWatcher getFileWatcher() {
        return this.getFactory().getFileWatcher(this);
    }
}

