/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipcutil;

import com.cisco.pt.IPAddress;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.events.IPCEventManager;
import com.cisco.pt.ipc.events.PingProcessEvent;
import com.cisco.pt.ipc.events.PingProcessEventListener;
import com.cisco.pt.ipc.sim.Device;
import com.cisco.pt.ipc.sim.ICMPProcess;
import com.cisco.pt.ipc.sim.Network;
import com.cisco.pt.ipc.sim.PingProcess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingUtil {
    private static Log logger = LogFactory.getLog(PingUtil.class);
    private IPCFactory ipcFacto;
    private IPCEventManager eventMgr;
    private int receivedCount;
    private boolean done;
    private final Object lock = new Object();

    public PingUtil(IPCFactory ipcFactory, IPCEventManager eventManager) {
        this.ipcFacto = ipcFactory;
        this.eventMgr = eventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPing(String deviceName, IPAddress dstIpAddress, int repeatTime, int timeout) {
        boolean result = false;
        this.receivedCount = 0;
        this.done = false;
        boolean listenerAdded = false;
        PingProcessEventListener pingClient = new PingProcessEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(PingProcessEvent evt) {
                if (evt instanceof PingProcessEvent.DonePing) {
                    PingProcessEvent.DonePing donePing = (PingProcessEvent.DonePing)evt;
                    PingUtil.this.receivedCount = donePing.receiveCount;
                    Object object = PingUtil.this.lock;
                    synchronized (object) {
                        PingUtil.this.done = true;
                        PingUtil.this.lock.notifyAll();
                    }
                }
            }
        };
        try {
            Network network = this.ipcFacto.network(this.ipcFacto.getIPC());
            Device device = network.getDevice(deviceName);
            ICMPProcess icmp = (ICMPProcess)device.getProcess("IcmpProcess");
            short pingId = icmp.createPingProcess(dstIpAddress, repeatTime, timeout, 100, "");
            PingProcess pingProcess = icmp.getPingProcess(pingId);
            this.eventMgr.getPingProcessEvents().addListener(pingClient, pingProcess);
            listenerAdded = true;
            pingProcess.start();
            Object object = this.lock;
            synchronized (object) {
                while (!this.done) {
                    this.lock.wait();
                }
            }
            result = this.receivedCount / repeatTime == 1;
        }
        catch (Exception e) {
            logger.warn((Object)("Error sending ping: " + e.getMessage()));
        }
        finally {
            try {
                if (!listenerAdded) {
                    this.eventMgr.getPingProcessEvents().removeListener(pingClient);
                }
            }
            catch (Exception e) {
                System.err.println("IPC Ping Util thrown exception on remove listener.");
                e.printStackTrace();
            }
        }
        return result;
    }
}

