/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.launcher;

import com.cisco.pt.launcher.PacketTracerLaunchException;
import com.cisco.pt.launcher.PacketTracerLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LinuxPacketTracerLauncher
extends PacketTracerLauncher {
    protected LinuxPacketTracerLauncher(File homeDirectory) throws PacketTracerLaunchException {
        super(homeDirectory);
    }

    @Override
    protected String getExecutableString() {
        return this.getHomeDirectory() + "/" + this.getExecutableFullName();
    }

    @Override
    public File getSaveDirectory() {
        return new File(this.homeDirectory, "SAVES");
    }

    @Override
    public String getExecutableFullName() {
        return "packettracer";
    }

    @Override
    protected String getDefaultHome() {
        return "/opt/pt";
    }

    @Override
    protected String getPathVariable() {
        return "PATH";
    }

    @Override
    protected String getPathSeparator() {
        return ":";
    }

    @Override
    public String getPttpHome() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader("/usr/share/applications/cisco-ptsa.desktop"));
            String line = reader.readLine();
            while (line != null) {
                line = reader.readLine();
                if (!line.startsWith("Exec=")) continue;
                line = line.substring(line.indexOf("Exec=") + 5, line.indexOf("/packettracer"));
                return line;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return ":";
        }
        return ":";
    }

    @Override
    protected List<String> getCommandTokens(int ipcPort, boolean noGui, File targetFile) throws Exception {
        ArrayList<String> commandTokens = new ArrayList<String>();
        commandTokens.add(this.wrapToken(this.getExecutableString()));
        if (noGui) {
            commandTokens.add(this.wrapToken("--no-gui"));
        }
        if (ipcPort != 0) {
            commandTokens.add(this.wrapToken("--ipc-port"));
            commandTokens.add(this.wrapToken(String.valueOf(ipcPort)));
        }
        if (targetFile != null) {
            commandTokens.add(this.wrapToken(targetFile.getCanonicalPath()));
        }
        return commandTokens;
    }
}

